/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;

public class DeleteStackSetRequestMarshaller
implements Marshaller<Request<DeleteStackSetRequest>, DeleteStackSetRequest> {
    public Request<DeleteStackSetRequest> marshall(DeleteStackSetRequest deleteStackSetRequest) {
        if (deleteStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)deleteStackSetRequest.stackSetName()));
        }
        return request;
    }
}

