/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudformation.model.AccountGateResult;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSetOperationResultSummary
implements ToCopyableBuilder<Builder, StackSetOperationResultSummary> {
    private final String account;
    private final String region;
    private final String status;
    private final String statusReason;
    private final AccountGateResult accountGateResult;

    private StackSetOperationResultSummary(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGateResult = builder.accountGateResult;
    }

    public String account() {
        return this.account;
    }

    public String region() {
        return this.region;
    }

    public StackSetOperationResultStatus status() {
        return StackSetOperationResultStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public AccountGateResult accountGateResult() {
        return this.accountGateResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGateResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationResultSummary)) {
            return false;
        }
        StackSetOperationResultSummary other = (StackSetOperationResultSummary)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.accountGateResult(), other.accountGateResult());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.account() != null) {
            sb.append("Account: ").append(this.account()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.accountGateResult() != null) {
            sb.append("AccountGateResult: ").append(this.accountGateResult()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.of(clazz.cast(this.account()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "AccountGateResult": {
                return Optional.of(clazz.cast(this.accountGateResult()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private String region;
        private String status;
        private String statusReason;
        private AccountGateResult accountGateResult;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationResultSummary model) {
            this.account(model.account);
            this.region(model.region);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.accountGateResult(model.accountGateResult);
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationResultStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final AccountGateResult.Builder getAccountGateResult() {
            return this.accountGateResult != null ? this.accountGateResult.toBuilder() : null;
        }

        @Override
        public final Builder accountGateResult(AccountGateResult accountGateResult) {
            this.accountGateResult = accountGateResult;
            return this;
        }

        public final void setAccountGateResult(AccountGateResult.BuilderImpl accountGateResult) {
            this.accountGateResult = accountGateResult != null ? accountGateResult.build() : null;
        }

        public StackSetOperationResultSummary build() {
            return new StackSetOperationResultSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSetOperationResultSummary> {
        public Builder account(String var1);

        public Builder region(String var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationResultStatus var1);

        public Builder statusReason(String var1);

        public Builder accountGateResult(AccountGateResult var1);

        default public Builder accountGateResult(Consumer<AccountGateResult.Builder> accountGateResult) {
            return this.accountGateResult((AccountGateResult)((AccountGateResult.Builder)AccountGateResult.builder().apply(accountGateResult)).build());
        }
    }
}

