/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateSummaryRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, GetTemplateSummaryRequest> {
    private final String templateBody;
    private final String templateURL;
    private final String stackName;
    private final String stackSetName;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
        this.stackSetName = builder.stackSetName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public String stackName() {
        return this.stackName;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackSetName(), other.stackSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.templateURL() != null) {
            sb.append("TemplateURL: ").append(this.templateURL()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.of(clazz.cast(this.templateURL()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String templateBody;
        private String templateURL;
        private String stackName;
        private String stackSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.stackName(model.stackName);
            this.stackSetName(model.stackSetName);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder stackName(String var1);

        public Builder stackSetName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

