/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final Boolean usePreviousTemplate;
    private final String stackPolicyDuringUpdateBody;
    private final String stackPolicyDuringUpdateURL;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final String stackPolicyBody;
    private final String stackPolicyURL;
    private final List<String> notificationARNs;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private UpdateStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.stackPolicyDuringUpdateBody = builder.stackPolicyDuringUpdateBody;
        this.stackPolicyDuringUpdateURL = builder.stackPolicyDuringUpdateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public Boolean usePreviousTemplate() {
        return this.usePreviousTemplate;
    }

    public String stackPolicyDuringUpdateBody() {
        return this.stackPolicyDuringUpdateBody;
    }

    public String stackPolicyDuringUpdateURL() {
        return this.stackPolicyDuringUpdateURL;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String stackPolicyBody() {
        return this.stackPolicyBody;
    }

    public String stackPolicyURL() {
        return this.stackPolicyURL;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.templateBody() == null ? 0 : this.templateBody().hashCode());
        hashCode = 31 * hashCode + (this.templateURL() == null ? 0 : this.templateURL().hashCode());
        hashCode = 31 * hashCode + (this.usePreviousTemplate() == null ? 0 : this.usePreviousTemplate().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyDuringUpdateBody() == null ? 0 : this.stackPolicyDuringUpdateBody().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyDuringUpdateURL() == null ? 0 : this.stackPolicyDuringUpdateURL().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.capabilitiesStrings() == null ? 0 : this.capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyBody() == null ? 0 : this.stackPolicyBody().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyURL() == null ? 0 : this.stackPolicyURL().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.templateURL() == null ^ this.templateURL() == null) {
            return false;
        }
        if (other.templateURL() != null && !other.templateURL().equals(this.templateURL())) {
            return false;
        }
        if (other.usePreviousTemplate() == null ^ this.usePreviousTemplate() == null) {
            return false;
        }
        if (other.usePreviousTemplate() != null && !other.usePreviousTemplate().equals(this.usePreviousTemplate())) {
            return false;
        }
        if (other.stackPolicyDuringUpdateBody() == null ^ this.stackPolicyDuringUpdateBody() == null) {
            return false;
        }
        if (other.stackPolicyDuringUpdateBody() != null && !other.stackPolicyDuringUpdateBody().equals(this.stackPolicyDuringUpdateBody())) {
            return false;
        }
        if (other.stackPolicyDuringUpdateURL() == null ^ this.stackPolicyDuringUpdateURL() == null) {
            return false;
        }
        if (other.stackPolicyDuringUpdateURL() != null && !other.stackPolicyDuringUpdateURL().equals(this.stackPolicyDuringUpdateURL())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.stackPolicyBody() == null ^ this.stackPolicyBody() == null) {
            return false;
        }
        if (other.stackPolicyBody() != null && !other.stackPolicyBody().equals(this.stackPolicyBody())) {
            return false;
        }
        if (other.stackPolicyURL() == null ^ this.stackPolicyURL() == null) {
            return false;
        }
        if (other.stackPolicyURL() != null && !other.stackPolicyURL().equals(this.stackPolicyURL())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        return other.clientRequestToken() == null || other.clientRequestToken().equals(this.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.templateURL() != null) {
            sb.append("TemplateURL: ").append(this.templateURL()).append(",");
        }
        if (this.usePreviousTemplate() != null) {
            sb.append("UsePreviousTemplate: ").append(this.usePreviousTemplate()).append(",");
        }
        if (this.stackPolicyDuringUpdateBody() != null) {
            sb.append("StackPolicyDuringUpdateBody: ").append(this.stackPolicyDuringUpdateBody()).append(",");
        }
        if (this.stackPolicyDuringUpdateURL() != null) {
            sb.append("StackPolicyDuringUpdateURL: ").append(this.stackPolicyDuringUpdateURL()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(this.capabilitiesStrings()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(this.stackPolicyBody()).append(",");
        }
        if (this.stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(this.stackPolicyURL()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.of(clazz.cast(this.templateURL()));
            }
            case "UsePreviousTemplate": {
                return Optional.of(clazz.cast(this.usePreviousTemplate()));
            }
            case "StackPolicyDuringUpdateBody": {
                return Optional.of(clazz.cast(this.stackPolicyDuringUpdateBody()));
            }
            case "StackPolicyDuringUpdateURL": {
                return Optional.of(clazz.cast(this.stackPolicyDuringUpdateURL()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "ResourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypes()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "StackPolicyBody": {
                return Optional.of(clazz.cast(this.stackPolicyBody()));
            }
            case "StackPolicyURL": {
                return Optional.of(clazz.cast(this.stackPolicyURL()));
            }
            case "NotificationARNs": {
                return Optional.of(clazz.cast(this.notificationARNs()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private Boolean usePreviousTemplate;
        private String stackPolicyDuringUpdateBody;
        private String stackPolicyDuringUpdateURL;
        private List<Parameter> parameters;
        private List<String> capabilities;
        private List<String> resourceTypes;
        private String roleARN;
        private String stackPolicyBody;
        private String stackPolicyURL;
        private List<String> notificationARNs;
        private List<Tag> tags;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            this.stackName(model.stackName);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.usePreviousTemplate(model.usePreviousTemplate);
            this.stackPolicyDuringUpdateBody(model.stackPolicyDuringUpdateBody);
            this.stackPolicyDuringUpdateURL(model.stackPolicyDuringUpdateURL);
            this.parameters(model.parameters);
            this.capabilities(model.capabilities);
            this.resourceTypes(model.resourceTypes);
            this.roleARN(model.roleARN);
            this.stackPolicyBody(model.stackPolicyBody);
            this.stackPolicyURL(model.stackPolicyURL);
            this.notificationARNs(model.notificationARNs);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return this.usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final String getStackPolicyDuringUpdateBody() {
            return this.stackPolicyDuringUpdateBody;
        }

        @Override
        public final Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
            return this;
        }

        public final void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        }

        public final String getStackPolicyDuringUpdateURL() {
            return this.stackPolicyDuringUpdateURL;
        }

        @Override
        public final Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
            return this;
        }

        public final void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getStackPolicyBody() {
            return this.stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return this.stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder usePreviousTemplate(Boolean var1);

        public Builder stackPolicyDuringUpdateBody(String var1);

        public Builder stackPolicyDuringUpdateURL(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder stackPolicyBody(String var1);

        public Builder stackPolicyURL(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder clientRequestToken(String var1);
    }
}

