/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.OutputsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Stack
implements ToCopyableBuilder<Builder, Stack> {
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String description;
    private final List<Parameter> parameters;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String stackStatus;
    private final String stackStatusReason;
    private final Boolean disableRollback;
    private final List<String> notificationARNs;
    private final Integer timeoutInMinutes;
    private final List<String> capabilities;
    private final List<Output> outputs;
    private final String roleARN;
    private final List<Tag> tags;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.disableRollback = builder.disableRollback;
        this.notificationARNs = builder.notificationARNs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.capabilities = builder.capabilities;
        this.outputs = builder.outputs;
        this.roleARN = builder.roleARN;
        this.tags = builder.tags;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String description() {
        return this.description;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public StackStatus stackStatus() {
        return StackStatus.fromValue(this.stackStatus);
    }

    public String stackStatusString() {
        return this.stackStatus;
    }

    public String stackStatusReason() {
        return this.stackStatusReason;
    }

    public Boolean disableRollback() {
        return this.disableRollback;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.changeSetId() == null ? 0 : this.changeSetId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.stackStatusString() == null ? 0 : this.stackStatusString().hashCode());
        hashCode = 31 * hashCode + (this.stackStatusReason() == null ? 0 : this.stackStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.disableRollback() == null ? 0 : this.disableRollback().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.capabilitiesStrings() == null ? 0 : this.capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.stackStatusString() == null ^ this.stackStatusString() == null) {
            return false;
        }
        if (other.stackStatusString() != null && !other.stackStatusString().equals(this.stackStatusString())) {
            return false;
        }
        if (other.stackStatusReason() == null ^ this.stackStatusReason() == null) {
            return false;
        }
        if (other.stackStatusReason() != null && !other.stackStatusReason().equals(this.stackStatusReason())) {
            return false;
        }
        if (other.disableRollback() == null ^ this.disableRollback() == null) {
            return false;
        }
        if (other.disableRollback() != null && !other.disableRollback().equals(this.disableRollback())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.changeSetId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (this.stackStatusString() != null) {
            sb.append("StackStatus: ").append(this.stackStatusString()).append(",");
        }
        if (this.stackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(this.stackStatusReason()).append(",");
        }
        if (this.disableRollback() != null) {
            sb.append("DisableRollback: ").append(this.disableRollback()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(this.capabilitiesStrings()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "ChangeSetId": {
                return Optional.of(clazz.cast(this.changeSetId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
            case "StackStatus": {
                return Optional.of(clazz.cast(this.stackStatusString()));
            }
            case "StackStatusReason": {
                return Optional.of(clazz.cast(this.stackStatusReason()));
            }
            case "DisableRollback": {
                return Optional.of(clazz.cast(this.disableRollback()));
            }
            case "NotificationARNs": {
                return Optional.of(clazz.cast(this.notificationARNs()));
            }
            case "TimeoutInMinutes": {
                return Optional.of(clazz.cast(this.timeoutInMinutes()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "Outputs": {
                return Optional.of(clazz.cast(this.outputs()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String description;
        private List<Parameter> parameters;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String stackStatus;
        private String stackStatusReason;
        private Boolean disableRollback;
        private List<String> notificationARNs;
        private Integer timeoutInMinutes;
        private List<String> capabilities;
        private List<Output> outputs;
        private String roleARN;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.changeSetId(model.changeSetId);
            this.description(model.description);
            this.parameters(model.parameters);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.stackStatus(model.stackStatus);
            this.stackStatusReason(model.stackStatusReason);
            this.disableRollback(model.disableRollback);
            this.notificationARNs(model.notificationARNs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.capabilities(model.capabilities);
            this.outputs(model.outputs);
            this.roleARN(model.roleARN);
            this.tags(model.tags);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final Boolean getDisableRollback() {
            return this.disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public Stack build() {
            return new Stack(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Stack> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder stackStatus(String var1);

        public Builder stackStatus(StackStatus var1);

        public Builder stackStatusReason(String var1);

        public Builder disableRollback(Boolean var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder roleARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

