/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeChangeSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeChangeSetRequest> {
    private final String changeSetName;
    private final String stackName;
    private final String nextToken;

    private DescribeChangeSetRequest(BuilderImpl builder) {
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
        this.nextToken = builder.nextToken;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String stackName() {
        return this.stackName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.changeSetName() == null ? 0 : this.changeSetName().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetRequest)) {
            return false;
        }
        DescribeChangeSetRequest other = (DescribeChangeSetRequest)((Object)obj);
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetName": {
                return Optional.of(clazz.cast(this.changeSetName()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String changeSetName;
        private String stackName;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetRequest model) {
            this.changeSetName(model.changeSetName);
            this.stackName(model.stackName);
            this.nextToken(model.nextToken);
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeChangeSetRequest build() {
            return new DescribeChangeSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeChangeSetRequest> {
        public Builder changeSetName(String var1);

        public Builder stackName(String var1);

        public Builder nextToken(String var1);
    }
}

