/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Output
implements ToCopyableBuilder<Builder, Output> {
    private final String outputKey;
    private final String outputValue;
    private final String description;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
    }

    public String outputKey() {
        return this.outputKey;
    }

    public String outputValue() {
        return this.outputValue;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputKey() == null ? 0 : this.outputKey().hashCode());
        hashCode = 31 * hashCode + (this.outputValue() == null ? 0 : this.outputValue().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        if (other.outputKey() == null ^ this.outputKey() == null) {
            return false;
        }
        if (other.outputKey() != null && !other.outputKey().equals(this.outputKey())) {
            return false;
        }
        if (other.outputValue() == null ^ this.outputValue() == null) {
            return false;
        }
        if (other.outputValue() != null && !other.outputValue().equals(this.outputValue())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputKey() != null) {
            sb.append("OutputKey: ").append(this.outputKey()).append(",");
        }
        if (this.outputValue() != null) {
            sb.append("OutputValue: ").append(this.outputValue()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputKey;
        private String outputValue;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.setOutputKey(model.outputKey);
            this.setOutputValue(model.outputValue);
            this.setDescription(model.description);
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return this.outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public Output build() {
            return new Output(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Output> {
        public Builder outputKey(String var1);

        public Builder outputValue(String var1);

        public Builder description(String var1);
    }
}

