/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;
import software.amazon.awssdk.services.cloudformation.model.StackEventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStackEventsResponse> {
    private final List<StackEvent> stackEvents;
    private final String nextToken;

    private DescribeStackEventsResponse(BuilderImpl builder) {
        this.stackEvents = builder.stackEvents;
        this.nextToken = builder.nextToken;
    }

    public List<StackEvent> stackEvents() {
        return this.stackEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackEvents() == null ? 0 : this.stackEvents().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackEventsResponse)) {
            return false;
        }
        DescribeStackEventsResponse other = (DescribeStackEventsResponse)((Object)obj);
        if (other.stackEvents() == null ^ this.stackEvents() == null) {
            return false;
        }
        if (other.stackEvents() != null && !other.stackEvents().equals(this.stackEvents())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackEvents() != null) {
            sb.append("StackEvents: ").append(this.stackEvents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StackEvent> stackEvents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackEventsResponse model) {
            this.setStackEvents(model.stackEvents);
            this.setNextToken(model.nextToken);
        }

        public final Collection<StackEvent> getStackEvents() {
            return this.stackEvents;
        }

        @Override
        public final Builder stackEvents(Collection<StackEvent> stackEvents) {
            this.stackEvents = StackEventsCopier.copy(stackEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackEvents(StackEvent ... stackEvents) {
            this.stackEvents(Arrays.asList(stackEvents));
            return this;
        }

        public final void setStackEvents(Collection<StackEvent> stackEvents) {
            this.stackEvents = StackEventsCopier.copy(stackEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeStackEventsResponse build() {
            return new DescribeStackEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackEventsResponse> {
        public Builder stackEvents(Collection<StackEvent> var1);

        public Builder stackEvents(StackEvent ... var1);

        public Builder nextToken(String var1);
    }
}

