/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;

public class ListImportsResponseUnmarshaller
implements Unmarshaller<ListImportsResponse, StaxUnmarshallerContext> {
    private static ListImportsResponseUnmarshaller INSTANCE;

    public ListImportsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListImportsResponse.Builder listImportsResponse;
        block6: {
            listImportsResponse = ListImportsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            ArrayList<String> imports = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listImportsResponse.imports(imports);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Imports", targetDepth)) {
                        imports = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Imports/member", targetDepth)) {
                        imports.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("NextToken", targetDepth)) continue;
                    listImportsResponse.nextToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listImportsResponse.imports(imports);
        }
        return (ListImportsResponse)((Object)listImportsResponse.build());
    }

    public static ListImportsResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListImportsResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

