/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.StageListCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private final String templateBody;
    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public List<String> stagesAvailable() {
        return this.stagesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.templateBody() == null ? 0 : this.templateBody().hashCode());
        hashCode = 31 * hashCode + (this.stagesAvailable() == null ? 0 : this.stagesAvailable().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.stagesAvailable() == null ^ this.stagesAvailable() == null) {
            return false;
        }
        return other.stagesAvailable() == null || other.stagesAvailable().equals(this.stagesAvailable());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.stagesAvailable() != null) {
            sb.append("StagesAvailable: ").append(this.stagesAvailable()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String templateBody;
        private List<String> stagesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            this.setTemplateBody(model.templateBody);
            this.setStagesAvailable(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<String> getStagesAvailable() {
            return this.stagesAvailable;
        }

        @Override
        public final Builder stagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(String ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(TemplateStage ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @SafeVarargs
        public final void setStagesAvailable(String ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable));
        }

        @SafeVarargs
        public final void setStagesAvailable(TemplateStage ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder templateBody(String var1);

        public Builder stagesAvailable(Collection<String> var1);

        public Builder stagesAvailable(String ... var1);

        public Builder stagesAvailable(TemplateStage ... var1);
    }
}

