/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.RetainResourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteStackRequest> {
    private final String stackName;
    private final List<String> retainResources;
    private final String roleARN;
    private final String clientRequestToken;

    private DeleteStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.retainResources = builder.retainResources;
        this.roleARN = builder.roleARN;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public List<String> retainResources() {
        return this.retainResources;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.retainResources() == null ? 0 : this.retainResources().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackRequest)) {
            return false;
        }
        DeleteStackRequest other = (DeleteStackRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.retainResources() == null ^ this.retainResources() == null) {
            return false;
        }
        if (other.retainResources() != null && !other.retainResources().equals(this.retainResources())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        return other.clientRequestToken() == null || other.clientRequestToken().equals(this.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.retainResources() != null) {
            sb.append("RetainResources: ").append(this.retainResources()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private List<String> retainResources;
        private String roleARN;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackRequest model) {
            this.setStackName(model.stackName);
            this.setRetainResources(model.retainResources);
            this.setRoleARN(model.roleARN);
            this.setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final Collection<String> getRetainResources() {
            return this.retainResources;
        }

        @Override
        public final Builder retainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainResources(String ... retainResources) {
            this.retainResources(Arrays.asList(retainResources));
            return this;
        }

        public final void setRetainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
        }

        @SafeVarargs
        public final void setRetainResources(String ... retainResources) {
            this.retainResources(Arrays.asList(retainResources));
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public DeleteStackRequest build() {
            return new DeleteStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteStackRequest> {
        public Builder stackName(String var1);

        public Builder retainResources(Collection<String> var1);

        public Builder retainResources(String ... var1);

        public Builder roleARN(String var1);

        public Builder clientRequestToken(String var1);
    }
}

