/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus;
import software.amazon.awssdk.services.cloudformation.model.ExecutionStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeSetSummary
implements ToCopyableBuilder<Builder, ChangeSetSummary> {
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String changeSetName;
    private final String executionStatus;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final String description;

    private ChangeSetSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String executionStatus() {
        return this.executionStatus;
    }

    public String status() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.changeSetId() == null ? 0 : this.changeSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeSetName() == null ? 0 : this.changeSetName().hashCode());
        hashCode = 31 * hashCode + (this.executionStatus() == null ? 0 : this.executionStatus().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummary)) {
            return false;
        }
        ChangeSetSummary other = (ChangeSetSummary)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.executionStatus() == null ^ this.executionStatus() == null) {
            return false;
        }
        if (other.executionStatus() != null && !other.executionStatus().equals(this.executionStatus())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.changeSetId()).append(",");
        }
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.executionStatus() != null) {
            sb.append("ExecutionStatus: ").append(this.executionStatus()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String changeSetName;
        private String executionStatus;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummary model) {
            this.setStackId(model.stackId);
            this.setStackName(model.stackName);
            this.setChangeSetId(model.changeSetId);
            this.setChangeSetName(model.changeSetName);
            this.setExecutionStatus(model.executionStatus);
            this.setStatus(model.status);
            this.setStatusReason(model.statusReason);
            this.setCreationTime(model.creationTime);
            this.setDescription(model.description);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final void setExecutionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ChangeSetStatus status) {
            this.status(status.toString());
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ChangeSetSummary build() {
            return new ChangeSetSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeSetSummary> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder changeSetName(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder status(String var1);

        public Builder status(ChangeSetStatus var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);
    }
}

