/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.transform.AlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ChangeSetNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.InsufficientCapabilitiesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.InvalidChangeSetStatusExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.LimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TokenAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationClientWaiters;

@SdkInternalApi
final class DefaultCloudFormationClient
implements CloudFormationClient {
    private final ClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    private final AwsSyncClientParams clientParams;
    private volatile CloudFormationClientWaiters waiters;

    protected DefaultCloudFormationClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CancelUpdateStackResponse cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) throws TokenAlreadyExistsException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CancelUpdateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CancelUpdateStackResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)cancelUpdateStackRequest).withMarshaller((Marshaller)new CancelUpdateStackRequestMarshaller())));
    }

    @Override
    public ContinueUpdateRollbackResponse continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) throws TokenAlreadyExistsException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ContinueUpdateRollbackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ContinueUpdateRollbackResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)continueUpdateRollbackRequest).withMarshaller((Marshaller)new ContinueUpdateRollbackRequestMarshaller())));
    }

    @Override
    public CreateChangeSetResponse createChangeSet(CreateChangeSetRequest createChangeSetRequest) throws AlreadyExistsException, InsufficientCapabilitiesException, LimitExceededException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateChangeSetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)createChangeSetRequest).withMarshaller((Marshaller)new CreateChangeSetRequestMarshaller())));
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException, AlreadyExistsException, TokenAlreadyExistsException, InsufficientCapabilitiesException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateStackResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)createStackRequest).withMarshaller((Marshaller)new CreateStackRequestMarshaller())));
    }

    @Override
    public DeleteChangeSetResponse deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) throws InvalidChangeSetStatusException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteChangeSetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteChangeSetRequest).withMarshaller((Marshaller)new DeleteChangeSetRequestMarshaller())));
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws TokenAlreadyExistsException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteStackResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteStackRequest).withMarshaller((Marshaller)new DeleteStackRequestMarshaller())));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits() throws SdkBaseException, SdkClientException, CloudFormationException {
        return this.describeAccountLimits((DescribeAccountLimitsRequest)((Object)DescribeAccountLimitsRequest.builder().build()));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAccountLimitsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeAccountLimitsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller())));
    }

    @Override
    public DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) throws ChangeSetNotFoundException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeChangeSetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeChangeSetRequest).withMarshaller((Marshaller)new DescribeChangeSetRequestMarshaller())));
    }

    @Override
    public DescribeStackEventsResponse describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackEventsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackEventsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeStackEventsRequest).withMarshaller((Marshaller)new DescribeStackEventsRequestMarshaller())));
    }

    @Override
    public DescribeStackResourceResponse describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackResourceResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeStackResourceRequest).withMarshaller((Marshaller)new DescribeStackResourceRequestMarshaller())));
    }

    @Override
    public DescribeStackResourcesResponse describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackResourcesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackResourcesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeStackResourcesRequest).withMarshaller((Marshaller)new DescribeStackResourcesRequestMarshaller())));
    }

    @Override
    public DescribeStacksResponse describeStacks() throws SdkBaseException, SdkClientException, CloudFormationException {
        return this.describeStacks((DescribeStacksRequest)((Object)DescribeStacksRequest.builder().build()));
    }

    @Override
    public DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStacksResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStacksResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)describeStacksRequest).withMarshaller((Marshaller)new DescribeStacksRequestMarshaller())));
    }

    @Override
    public EstimateTemplateCostResponse estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new EstimateTemplateCostResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (EstimateTemplateCostResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)estimateTemplateCostRequest).withMarshaller((Marshaller)new EstimateTemplateCostRequestMarshaller())));
    }

    @Override
    public ExecuteChangeSetResponse executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException, TokenAlreadyExistsException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ExecuteChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ExecuteChangeSetResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)executeChangeSetRequest).withMarshaller((Marshaller)new ExecuteChangeSetRequestMarshaller())));
    }

    @Override
    public GetStackPolicyResponse getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetStackPolicyResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetStackPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getStackPolicyRequest).withMarshaller((Marshaller)new GetStackPolicyRequestMarshaller())));
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ChangeSetNotFoundException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTemplateResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetTemplateResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getTemplateRequest).withMarshaller((Marshaller)new GetTemplateRequestMarshaller())));
    }

    @Override
    public GetTemplateSummaryResponse getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTemplateSummaryResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetTemplateSummaryResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getTemplateSummaryRequest).withMarshaller((Marshaller)new GetTemplateSummaryRequestMarshaller())));
    }

    @Override
    public ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListChangeSetsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListChangeSetsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listChangeSetsRequest).withMarshaller((Marshaller)new ListChangeSetsRequestMarshaller())));
    }

    @Override
    public ListExportsResponse listExports() throws SdkBaseException, SdkClientException, CloudFormationException {
        return this.listExports((ListExportsRequest)((Object)ListExportsRequest.builder().build()));
    }

    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListExportsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListExportsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listExportsRequest).withMarshaller((Marshaller)new ListExportsRequestMarshaller())));
    }

    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListImportsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListImportsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listImportsRequest).withMarshaller((Marshaller)new ListImportsRequestMarshaller())));
    }

    @Override
    public ListStackResourcesResponse listStackResources(ListStackResourcesRequest listStackResourcesRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackResourcesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackResourcesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listStackResourcesRequest).withMarshaller((Marshaller)new ListStackResourcesRequestMarshaller())));
    }

    @Override
    public ListStacksResponse listStacks() throws SdkBaseException, SdkClientException, CloudFormationException {
        return this.listStacks((ListStacksRequest)((Object)ListStacksRequest.builder().build()));
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest listStacksRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStacksResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStacksResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listStacksRequest).withMarshaller((Marshaller)new ListStacksRequestMarshaller())));
    }

    @Override
    public SetStackPolicyResponse setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetStackPolicyResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetStackPolicyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)setStackPolicyRequest).withMarshaller((Marshaller)new SetStackPolicyRequestMarshaller())));
    }

    @Override
    public SignalResourceResponse signalResource(SignalResourceRequest signalResourceRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SignalResourceResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SignalResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)signalResourceRequest).withMarshaller((Marshaller)new SignalResourceRequestMarshaller())));
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws InsufficientCapabilitiesException, TokenAlreadyExistsException, SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UpdateStackResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)updateStackRequest).withMarshaller((Marshaller)new UpdateStackRequestMarshaller())));
    }

    @Override
    public ValidateTemplateResponse validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws SdkBaseException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ValidateTemplateResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ValidateTemplateResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)validateTemplateRequest).withMarshaller((Marshaller)new ValidateTemplateRequestMarshaller())));
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidChangeSetStatusExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InsufficientCapabilitiesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TokenAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ChangeSetNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(CloudFormationException.class));
        return unmarshallers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudFormationClientWaiters waiters() {
        if (this.waiters == null) {
            DefaultCloudFormationClient defaultCloudFormationClient = this;
            synchronized (defaultCloudFormationClient) {
                if (this.waiters == null) {
                    this.waiters = new CloudFormationClientWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

