/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;

public class ListStackResourcesPublisher
implements SdkPublisher<ListStackResourcesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackResourcesPublisher(CloudFormationAsyncClient client, ListStackResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackResourcesPublisher(CloudFormationAsyncClient client, ListStackResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackResourceSummary> stackResourceSummaries() {
        Function<ListStackResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackResourceSummaries() != null) {
                return response.stackResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStackResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListStackResourcesPublisher resume(ListStackResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStackResourcesPublisher(this.client, (ListStackResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStackResourcesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListStackResourcesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListStackResourcesResponseFetcher
    implements AsyncPageFetcher<ListStackResourcesResponse> {
        private ListStackResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackResourcesResponse> nextPage(ListStackResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListStackResourcesPublisher.this.client.listStackResources(ListStackResourcesPublisher.this.firstRequest);
            }
            return ListStackResourcesPublisher.this.client.listStackResources((ListStackResourcesRequest)((Object)ListStackResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

