/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlResponse;
import software.amazon.awssdk.services.cloudcontrol.model.HookProgressEvent;
import software.amazon.awssdk.services.cloudcontrol.model.HooksProgressEventCopier;
import software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceRequestStatusResponse
extends CloudControlResponse
implements ToCopyableBuilder<Builder, GetResourceRequestStatusResponse> {
    private static final SdkField<ProgressEvent> PROGRESS_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressEvent").getter(GetResourceRequestStatusResponse.getter(GetResourceRequestStatusResponse::progressEvent)).setter(GetResourceRequestStatusResponse.setter(Builder::progressEvent)).constructor(ProgressEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressEvent").build()}).build();
    private static final SdkField<List<HookProgressEvent>> HOOKS_PROGRESS_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HooksProgressEvent").getter(GetResourceRequestStatusResponse.getter(GetResourceRequestStatusResponse::hooksProgressEvent)).setter(GetResourceRequestStatusResponse.setter(Builder::hooksProgressEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HooksProgressEvent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HookProgressEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_EVENT_FIELD, HOOKS_PROGRESS_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProgressEvent", PROGRESS_EVENT_FIELD);
            this.put("HooksProgressEvent", HOOKS_PROGRESS_EVENT_FIELD);
        }
    });
    private final ProgressEvent progressEvent;
    private final List<HookProgressEvent> hooksProgressEvent;

    private GetResourceRequestStatusResponse(BuilderImpl builder) {
        super(builder);
        this.progressEvent = builder.progressEvent;
        this.hooksProgressEvent = builder.hooksProgressEvent;
    }

    public final ProgressEvent progressEvent() {
        return this.progressEvent;
    }

    public final boolean hasHooksProgressEvent() {
        return this.hooksProgressEvent != null && !(this.hooksProgressEvent instanceof SdkAutoConstructList);
    }

    public final List<HookProgressEvent> hooksProgressEvent() {
        return this.hooksProgressEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.progressEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHooksProgressEvent() ? this.hooksProgressEvent() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceRequestStatusResponse)) {
            return false;
        }
        GetResourceRequestStatusResponse other = (GetResourceRequestStatusResponse)((Object)obj);
        return Objects.equals(this.progressEvent(), other.progressEvent()) && this.hasHooksProgressEvent() == other.hasHooksProgressEvent() && Objects.equals(this.hooksProgressEvent(), other.hooksProgressEvent());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceRequestStatusResponse").add("ProgressEvent", (Object)this.progressEvent()).add("HooksProgressEvent", this.hasHooksProgressEvent() ? this.hooksProgressEvent() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressEvent": {
                return Optional.ofNullable(clazz.cast(this.progressEvent()));
            }
            case "HooksProgressEvent": {
                return Optional.ofNullable(clazz.cast(this.hooksProgressEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceRequestStatusResponse, T> g) {
        return obj -> g.apply((GetResourceRequestStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlResponse.BuilderImpl
    implements Builder {
        private ProgressEvent progressEvent;
        private List<HookProgressEvent> hooksProgressEvent = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceRequestStatusResponse model) {
            super(model);
            this.progressEvent(model.progressEvent);
            this.hooksProgressEvent(model.hooksProgressEvent);
        }

        public final ProgressEvent.Builder getProgressEvent() {
            return this.progressEvent != null ? this.progressEvent.toBuilder() : null;
        }

        public final void setProgressEvent(ProgressEvent.BuilderImpl progressEvent) {
            this.progressEvent = progressEvent != null ? progressEvent.build() : null;
        }

        @Override
        public final Builder progressEvent(ProgressEvent progressEvent) {
            this.progressEvent = progressEvent;
            return this;
        }

        public final List<HookProgressEvent.Builder> getHooksProgressEvent() {
            List<HookProgressEvent.Builder> result = HooksProgressEventCopier.copyToBuilder(this.hooksProgressEvent);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHooksProgressEvent(Collection<HookProgressEvent.BuilderImpl> hooksProgressEvent) {
            this.hooksProgressEvent = HooksProgressEventCopier.copyFromBuilder(hooksProgressEvent);
        }

        @Override
        public final Builder hooksProgressEvent(Collection<HookProgressEvent> hooksProgressEvent) {
            this.hooksProgressEvent = HooksProgressEventCopier.copy(hooksProgressEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksProgressEvent(HookProgressEvent ... hooksProgressEvent) {
            this.hooksProgressEvent(Arrays.asList(hooksProgressEvent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksProgressEvent(Consumer<HookProgressEvent.Builder> ... hooksProgressEvent) {
            this.hooksProgressEvent(Stream.of(hooksProgressEvent).map(c -> (HookProgressEvent)((HookProgressEvent.Builder)HookProgressEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourceRequestStatusResponse build() {
            return new GetResourceRequestStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceRequestStatusResponse> {
        public Builder progressEvent(ProgressEvent var1);

        default public Builder progressEvent(Consumer<ProgressEvent.Builder> progressEvent) {
            return this.progressEvent((ProgressEvent)((ProgressEvent.Builder)ProgressEvent.builder().applyMutation(progressEvent)).build());
        }

        public Builder hooksProgressEvent(Collection<HookProgressEvent> var1);

        public Builder hooksProgressEvent(HookProgressEvent ... var1);

        public Builder hooksProgressEvent(Consumer<HookProgressEvent.Builder> ... var1);
    }
}

