/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudcontrol.CloudControlAsyncClient;
import software.amazon.awssdk.services.cloudcontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent;

public class ListResourceRequestsPublisher
implements SdkPublisher<ListResourceRequestsResponse> {
    private final CloudControlAsyncClient client;
    private final ListResourceRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceRequestsPublisher(CloudControlAsyncClient client, ListResourceRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceRequestsPublisher(CloudControlAsyncClient client, ListResourceRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProgressEvent> resourceRequestStatusSummaries() {
        Function<ListResourceRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceRequestStatusSummaries() != null) {
                return response.resourceRequestStatusSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceRequestsResponseFetcher
    implements AsyncPageFetcher<ListResourceRequestsResponse> {
        private ListResourceRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceRequestsResponse> nextPage(ListResourceRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRequestsPublisher.this.client.listResourceRequests(ListResourceRequestsPublisher.this.firstRequest);
            }
            return ListResourceRequestsPublisher.this.client.listResourceRequests((ListResourceRequestsRequest)((Object)ListResourceRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

