/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceResponse
extends CloudControlResponse
implements ToCopyableBuilder<Builder, GetResourceResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(GetResourceResponse.getter(GetResourceResponse::typeName)).setter(GetResourceResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<ResourceDescription> RESOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDescription").getter(GetResourceResponse.getter(GetResourceResponse::resourceDescription)).setter(GetResourceResponse.setter(Builder::resourceDescription)).constructor(ResourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, RESOURCE_DESCRIPTION_FIELD));
    private final String typeName;
    private final ResourceDescription resourceDescription;

    private GetResourceResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.resourceDescription = builder.resourceDescription;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final ResourceDescription resourceDescription() {
        return this.resourceDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceResponse)) {
            return false;
        }
        GetResourceResponse other = (GetResourceResponse)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.resourceDescription(), other.resourceDescription());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceResponse").add("TypeName", (Object)this.typeName()).add("ResourceDescription", (Object)this.resourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "ResourceDescription": {
                return Optional.ofNullable(clazz.cast(this.resourceDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceResponse, T> g) {
        return obj -> g.apply((GetResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlResponse.BuilderImpl
    implements Builder {
        private String typeName;
        private ResourceDescription resourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceResponse model) {
            super(model);
            this.typeName(model.typeName);
            this.resourceDescription(model.resourceDescription);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final ResourceDescription.Builder getResourceDescription() {
            return this.resourceDescription != null ? this.resourceDescription.toBuilder() : null;
        }

        public final void setResourceDescription(ResourceDescription.BuilderImpl resourceDescription) {
            this.resourceDescription = resourceDescription != null ? resourceDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceDescription(ResourceDescription resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        @Override
        public GetResourceResponse build() {
            return new GetResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceResponse> {
        public Builder typeName(String var1);

        public Builder resourceDescription(ResourceDescription var1);

        default public Builder resourceDescription(Consumer<ResourceDescription.Builder> resourceDescription) {
            return this.resourceDescription((ResourceDescription)((ResourceDescription.Builder)ResourceDescription.builder().applyMutation(resourceDescription)).build());
        }
    }
}

