/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Operation {
    CREATE("CREATE"),
    DELETE("DELETE"),
    UPDATE("UPDATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Operation> VALUE_MAP;
    private final String value;

    private Operation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Operation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Operation> knownValues() {
        EnumSet<Operation> knownValues = EnumSet.allOf(Operation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Operation.class, Operation::toString);
    }
}

