/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentEc2Request
extends Cloud9Request
implements ToCopyableBuilder<Builder, CreateEnvironmentEc2Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::name)).setter(CreateEnvironmentEc2Request.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::description)).setter(CreateEnvironmentEc2Request.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::clientRequestToken)).setter(CreateEnvironmentEc2Request.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::instanceType)).setter(CreateEnvironmentEc2Request.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::subnetId)).setter(CreateEnvironmentEc2Request.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_STOP_TIME_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::automaticStopTimeMinutes)).setter(CreateEnvironmentEc2Request.setter(Builder::automaticStopTimeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticStopTimeMinutes").build()}).build();
    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::ownerArn)).setter(CreateEnvironmentEc2Request.setter(Builder::ownerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, AUTOMATIC_STOP_TIME_MINUTES_FIELD, OWNER_ARN_FIELD));
    private final String name;
    private final String description;
    private final String clientRequestToken;
    private final String instanceType;
    private final String subnetId;
    private final Integer automaticStopTimeMinutes;
    private final String ownerArn;

    private CreateEnvironmentEc2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
        this.ownerArn = builder.ownerArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Integer automaticStopTimeMinutes() {
        return this.automaticStopTimeMinutes;
    }

    public String ownerArn() {
        return this.ownerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticStopTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentEc2Request)) {
            return false;
        }
        CreateEnvironmentEc2Request other = (CreateEnvironmentEc2Request)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.automaticStopTimeMinutes(), other.automaticStopTimeMinutes()) && Objects.equals(this.ownerArn(), other.ownerArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateEnvironmentEc2Request").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("InstanceType", (Object)this.instanceType()).add("SubnetId", (Object)this.subnetId()).add("AutomaticStopTimeMinutes", (Object)this.automaticStopTimeMinutes()).add("OwnerArn", (Object)this.ownerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "automaticStopTimeMinutes": {
                return Optional.ofNullable(clazz.cast(this.automaticStopTimeMinutes()));
            }
            case "ownerArn": {
                return Optional.ofNullable(clazz.cast(this.ownerArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentEc2Request, T> g) {
        return obj -> g.apply((CreateEnvironmentEc2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String clientRequestToken;
        private String instanceType;
        private String subnetId;
        private Integer automaticStopTimeMinutes;
        private String ownerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentEc2Request model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.automaticStopTimeMinutes(model.automaticStopTimeMinutes);
            this.ownerArn(model.ownerArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Integer getAutomaticStopTimeMinutes() {
            return this.automaticStopTimeMinutes;
        }

        @Override
        public final Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        public final void setAutomaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
        }

        public final String getOwnerArn() {
            return this.ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentEc2Request build() {
            return new CreateEnvironmentEc2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentEc2Request> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder instanceType(String var1);

        public Builder subnetId(String var1);

        public Builder automaticStopTimeMinutes(Integer var1);

        public Builder ownerArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

