/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.services.cloud9.model.ConnectionType;
import software.amazon.awssdk.services.cloud9.model.Tag;
import software.amazon.awssdk.services.cloud9.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentEc2Request
extends Cloud9Request
implements ToCopyableBuilder<Builder, CreateEnvironmentEc2Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::name)).setter(CreateEnvironmentEc2Request.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::description)).setter(CreateEnvironmentEc2Request.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::clientRequestToken)).setter(CreateEnvironmentEc2Request.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::instanceType)).setter(CreateEnvironmentEc2Request.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnetId").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::subnetId)).setter(CreateEnvironmentEc2Request.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::imageId)).setter(CreateEnvironmentEc2Request.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_STOP_TIME_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("automaticStopTimeMinutes").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::automaticStopTimeMinutes)).setter(CreateEnvironmentEc2Request.setter(Builder::automaticStopTimeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticStopTimeMinutes").build()}).build();
    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerArn").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::ownerArn)).setter(CreateEnvironmentEc2Request.setter(Builder::ownerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::tags)).setter(CreateEnvironmentEc2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionType").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::connectionTypeAsString)).setter(CreateEnvironmentEc2Request.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dryRun").getter(CreateEnvironmentEc2Request.getter(CreateEnvironmentEc2Request::dryRun)).setter(CreateEnvironmentEc2Request.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, IMAGE_ID_FIELD, AUTOMATIC_STOP_TIME_MINUTES_FIELD, OWNER_ARN_FIELD, TAGS_FIELD, CONNECTION_TYPE_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("subnetId", SUBNET_ID_FIELD);
            this.put("imageId", IMAGE_ID_FIELD);
            this.put("automaticStopTimeMinutes", AUTOMATIC_STOP_TIME_MINUTES_FIELD);
            this.put("ownerArn", OWNER_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("connectionType", CONNECTION_TYPE_FIELD);
            this.put("dryRun", DRY_RUN_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String clientRequestToken;
    private final String instanceType;
    private final String subnetId;
    private final String imageId;
    private final Integer automaticStopTimeMinutes;
    private final String ownerArn;
    private final List<Tag> tags;
    private final String connectionType;
    private final Boolean dryRun;

    private CreateEnvironmentEc2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.imageId = builder.imageId;
        this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
        this.ownerArn = builder.ownerArn;
        this.tags = builder.tags;
        this.connectionType = builder.connectionType;
        this.dryRun = builder.dryRun;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final Integer automaticStopTimeMinutes() {
        return this.automaticStopTimeMinutes;
    }

    public final String ownerArn() {
        return this.ownerArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticStopTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentEc2Request)) {
            return false;
        }
        CreateEnvironmentEc2Request other = (CreateEnvironmentEc2Request)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.automaticStopTimeMinutes(), other.automaticStopTimeMinutes()) && Objects.equals(this.ownerArn(), other.ownerArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentEc2Request").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)this.clientRequestToken()).add("InstanceType", (Object)this.instanceType()).add("SubnetId", (Object)this.subnetId()).add("ImageId", (Object)this.imageId()).add("AutomaticStopTimeMinutes", (Object)this.automaticStopTimeMinutes()).add("OwnerArn", (Object)this.ownerArn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectionType", (Object)this.connectionTypeAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "automaticStopTimeMinutes": {
                return Optional.ofNullable(clazz.cast(this.automaticStopTimeMinutes()));
            }
            case "ownerArn": {
                return Optional.ofNullable(clazz.cast(this.ownerArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "dryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentEc2Request, T> g) {
        return obj -> g.apply((CreateEnvironmentEc2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String clientRequestToken;
        private String instanceType;
        private String subnetId;
        private String imageId;
        private Integer automaticStopTimeMinutes;
        private String ownerArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String connectionType;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentEc2Request model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.imageId(model.imageId);
            this.automaticStopTimeMinutes(model.automaticStopTimeMinutes);
            this.ownerArn(model.ownerArn);
            this.tags(model.tags);
            this.connectionType(model.connectionType);
            this.dryRun(model.dryRun);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Integer getAutomaticStopTimeMinutes() {
            return this.automaticStopTimeMinutes;
        }

        public final void setAutomaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
        }

        @Override
        public final Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        public final String getOwnerArn() {
            return this.ownerArn;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentEc2Request build() {
            return new CreateEnvironmentEc2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentEc2Request> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder instanceType(String var1);

        public Builder subnetId(String var1);

        public Builder imageId(String var1);

        public Builder automaticStopTimeMinutes(Integer var1);

        public Builder ownerArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

