/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.Cloud9ClientBuilder;
import software.amazon.awssdk.services.cloud9.Cloud9ServiceClientConfiguration;
import software.amazon.awssdk.services.cloud9.DefaultCloud9BaseClientBuilder;
import software.amazon.awssdk.services.cloud9.DefaultCloud9Client;
import software.amazon.awssdk.services.cloud9.endpoints.Cloud9EndpointProvider;

@SdkInternalApi
final class DefaultCloud9ClientBuilder
extends DefaultCloud9BaseClientBuilder<Cloud9ClientBuilder, Cloud9Client>
implements Cloud9ClientBuilder {
    DefaultCloud9ClientBuilder() {
    }

    @Override
    public DefaultCloud9ClientBuilder endpointProvider(Cloud9EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Cloud9Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloud9ClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        Cloud9ServiceClientConfiguration serviceClientConfiguration = Cloud9ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloud9Client(serviceClientConfiguration, clientConfiguration);
    }
}

