/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloud9.model.BoundedEnvironmentIdListCopier;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentsRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, DescribeEnvironmentsRequest> {
    private static final SdkField<List<String>> ENVIRONMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentIds").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::environmentIds)).setter(DescribeEnvironmentsRequest.setter(Builder::environmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_IDS_FIELD));
    private final List<String> environmentIds;

    private DescribeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentIds = builder.environmentIds;
    }

    public boolean hasEnvironmentIds() {
        return this.environmentIds != null && !(this.environmentIds instanceof SdkAutoConstructList);
    }

    public List<String> environmentIds() {
        return this.environmentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.environmentIds(), other.environmentIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentsRequest").add("EnvironmentIds", this.environmentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentIds": {
                return Optional.ofNullable(clazz.cast(this.environmentIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private List<String> environmentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsRequest model) {
            super(model);
            this.environmentIds(model.environmentIds);
        }

        public final Collection<String> getEnvironmentIds() {
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = BoundedEnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            this.environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = BoundedEnvironmentIdListCopier.copy(environmentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentsRequest build() {
            return new DescribeEnvironmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentsRequest> {
        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

