/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCloud9WorkspaceManagementService.DescribeEnvironments").serviceName("AWS Cloud9").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEnvironmentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        Validate.paramNotNull((Object)((Object)describeEnvironmentsRequest), (String)"describeEnvironmentsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeEnvironmentsRequest);
            protocolMarshaller.startMarshalling();
            DescribeEnvironmentsRequestModelMarshaller.getInstance().marshall(describeEnvironmentsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

