/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloud9.model.Cloud9Response;
import software.amazon.awssdk.services.cloud9.model.EnvironmentIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEnvironmentsResponse
extends Cloud9Response
implements ToCopyableBuilder<Builder, ListEnvironmentsResponse> {
    private final String nextToken;
    private final List<String> environmentIds;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentIds = builder.environmentIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> environmentIds() {
        return this.environmentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.environmentIds(), other.environmentIds());
    }

    public String toString() {
        return ToString.builder((String)"ListEnvironmentsResponse").add("NextToken", (Object)this.nextToken()).add("EnvironmentIds", this.environmentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "environmentIds": {
                return Optional.of(clazz.cast(this.environmentIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> environmentIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            this.nextToken(model.nextToken);
            this.environmentIds(model.environmentIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getEnvironmentIds() {
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            this.environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends Cloud9Response.Builder,
    CopyableBuilder<Builder, ListEnvironmentsResponse> {
        public Builder nextToken(String var1);

        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);
    }
}

