/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloud9.model.Environment;

@SdkInternalApi
public class EnvironmentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> OWNERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerArn").build();
    private static final EnvironmentMarshaller INSTANCE = new EnvironmentMarshaller();

    public static EnvironmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Environment environment, ProtocolMarshaller protocolMarshaller) {
        if (environment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)environment.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)environment.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)environment.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)environment.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)environment.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)environment.ownerArn(), OWNERARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

