/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse;

public final class DescribeEnvironmentMembershipsPaginator
implements SdkIterable<DescribeEnvironmentMembershipsResponse> {
    private final Cloud9Client client;
    private final DescribeEnvironmentMembershipsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEnvironmentMembershipsPaginator(Cloud9Client client, DescribeEnvironmentMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEnvironmentMembershipsResponseFetcher();
    }

    public Iterator<DescribeEnvironmentMembershipsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeEnvironmentMembershipsResponseFetcher
    implements NextPageFetcher<DescribeEnvironmentMembershipsResponse> {
        private DescribeEnvironmentMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEnvironmentMembershipsResponse nextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEnvironmentMembershipsPaginator.this.client.describeEnvironmentMemberships(DescribeEnvironmentMembershipsPaginator.this.firstRequest);
            }
            return DescribeEnvironmentMembershipsPaginator.this.client.describeEnvironmentMemberships((DescribeEnvironmentMembershipsRequest)((Object)DescribeEnvironmentMembershipsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

