/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.PhoneNumberCountriesListCopier;
import software.amazon.awssdk.services.chime.model.PhoneNumberCountry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSupportedPhoneNumberCountriesResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListSupportedPhoneNumberCountriesResponse> {
    private static final SdkField<List<PhoneNumberCountry>> PHONE_NUMBER_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberCountries").getter(ListSupportedPhoneNumberCountriesResponse.getter(ListSupportedPhoneNumberCountriesResponse::phoneNumberCountries)).setter(ListSupportedPhoneNumberCountriesResponse.setter(Builder::phoneNumberCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberCountry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_COUNTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSupportedPhoneNumberCountriesResponse.memberNameToFieldInitializer();
    private final List<PhoneNumberCountry> phoneNumberCountries;

    private ListSupportedPhoneNumberCountriesResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberCountries = builder.phoneNumberCountries;
    }

    public final boolean hasPhoneNumberCountries() {
        return this.phoneNumberCountries != null && !(this.phoneNumberCountries instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberCountry> phoneNumberCountries() {
        return this.phoneNumberCountries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberCountries() ? this.phoneNumberCountries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedPhoneNumberCountriesResponse)) {
            return false;
        }
        ListSupportedPhoneNumberCountriesResponse other = (ListSupportedPhoneNumberCountriesResponse)((Object)obj);
        return this.hasPhoneNumberCountries() == other.hasPhoneNumberCountries() && Objects.equals(this.phoneNumberCountries(), other.phoneNumberCountries());
    }

    public final String toString() {
        return ToString.builder((String)"ListSupportedPhoneNumberCountriesResponse").add("PhoneNumberCountries", this.hasPhoneNumberCountries() ? this.phoneNumberCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberCountries": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PhoneNumberCountry>>> map = new HashMap<String, SdkField<List<PhoneNumberCountry>>>();
        map.put("PhoneNumberCountries", PHONE_NUMBER_COUNTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedPhoneNumberCountriesResponse, T> g) {
        return obj -> g.apply((ListSupportedPhoneNumberCountriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumberCountry> phoneNumberCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedPhoneNumberCountriesResponse model) {
            super(model);
            this.phoneNumberCountries(model.phoneNumberCountries);
        }

        public final List<PhoneNumberCountry.Builder> getPhoneNumberCountries() {
            List<PhoneNumberCountry.Builder> result = PhoneNumberCountriesListCopier.copyToBuilder(this.phoneNumberCountries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumberCountries(Collection<PhoneNumberCountry.BuilderImpl> phoneNumberCountries) {
            this.phoneNumberCountries = PhoneNumberCountriesListCopier.copyFromBuilder(phoneNumberCountries);
        }

        @Override
        public final Builder phoneNumberCountries(Collection<PhoneNumberCountry> phoneNumberCountries) {
            this.phoneNumberCountries = PhoneNumberCountriesListCopier.copy(phoneNumberCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountries(PhoneNumberCountry ... phoneNumberCountries) {
            this.phoneNumberCountries(Arrays.asList(phoneNumberCountries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountries(Consumer<PhoneNumberCountry.Builder> ... phoneNumberCountries) {
            this.phoneNumberCountries(Stream.of(phoneNumberCountries).map(c -> (PhoneNumberCountry)((PhoneNumberCountry.Builder)PhoneNumberCountry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSupportedPhoneNumberCountriesResponse build() {
            return new ListSupportedPhoneNumberCountriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSupportedPhoneNumberCountriesResponse> {
        public Builder phoneNumberCountries(Collection<PhoneNumberCountry> var1);

        public Builder phoneNumberCountries(PhoneNumberCountry ... var1);

        public Builder phoneNumberCountries(Consumer<PhoneNumberCountry.Builder> ... var1);
    }
}

