/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.ProxySession;
import software.amazon.awssdk.services.chime.model.ProxySessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProxySessionsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListProxySessionsResponse> {
    private static final SdkField<List<ProxySession>> PROXY_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProxySessions").getter(ListProxySessionsResponse.getter(ListProxySessionsResponse::proxySessions)).setter(ListProxySessionsResponse.setter(Builder::proxySessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxySessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxySession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProxySessionsResponse.getter(ListProxySessionsResponse::nextToken)).setter(ListProxySessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProxySessions", PROXY_SESSIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ProxySession> proxySessions;
    private final String nextToken;

    private ListProxySessionsResponse(BuilderImpl builder) {
        super(builder);
        this.proxySessions = builder.proxySessions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProxySessions() {
        return this.proxySessions != null && !(this.proxySessions instanceof SdkAutoConstructList);
    }

    public final List<ProxySession> proxySessions() {
        return this.proxySessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProxySessions() ? this.proxySessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProxySessionsResponse)) {
            return false;
        }
        ListProxySessionsResponse other = (ListProxySessionsResponse)((Object)obj);
        return this.hasProxySessions() == other.hasProxySessions() && Objects.equals(this.proxySessions(), other.proxySessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProxySessionsResponse").add("ProxySessions", this.hasProxySessions() ? this.proxySessions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxySessions": {
                return Optional.ofNullable(clazz.cast(this.proxySessions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProxySessionsResponse, T> g) {
        return obj -> g.apply((ListProxySessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<ProxySession> proxySessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProxySessionsResponse model) {
            super(model);
            this.proxySessions(model.proxySessions);
            this.nextToken(model.nextToken);
        }

        public final List<ProxySession.Builder> getProxySessions() {
            List<ProxySession.Builder> result = ProxySessionsCopier.copyToBuilder(this.proxySessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxySessions(Collection<ProxySession.BuilderImpl> proxySessions) {
            this.proxySessions = ProxySessionsCopier.copyFromBuilder(proxySessions);
        }

        @Override
        public final Builder proxySessions(Collection<ProxySession> proxySessions) {
            this.proxySessions = ProxySessionsCopier.copy(proxySessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxySessions(ProxySession ... proxySessions) {
            this.proxySessions(Arrays.asList(proxySessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxySessions(Consumer<ProxySession.Builder> ... proxySessions) {
            this.proxySessions(Stream.of(proxySessions).map(c -> (ProxySession)((ProxySession.Builder)ProxySession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProxySessionsResponse build() {
            return new ListProxySessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProxySessionsResponse> {
        public Builder proxySessions(Collection<ProxySession> var1);

        public Builder proxySessions(ProxySession ... var1);

        public Builder proxySessions(Consumer<ProxySession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

