/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListBotsRequest;
import software.amazon.awssdk.services.chime.model.ListBotsResponse;

public class ListBotsPublisher
implements SdkPublisher<ListBotsResponse> {
    private final ChimeAsyncClient client;
    private final ListBotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotsPublisher(ChimeAsyncClient client, ListBotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotsPublisher(ChimeAsyncClient client, ListBotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotsResponseFetcher
    implements AsyncPageFetcher<ListBotsResponse> {
        private ListBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotsResponse> nextPage(ListBotsResponse previousPage) {
            if (previousPage == null) {
                return ListBotsPublisher.this.client.listBots(ListBotsPublisher.this.firstRequest);
            }
            return ListBotsPublisher.this.client.listBots((ListBotsRequest)((Object)ListBotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

