/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.VoiceConnector;
import software.amazon.awssdk.services.chime.model.VoiceConnectorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVoiceConnectorsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListVoiceConnectorsResponse> {
    private static final SdkField<List<VoiceConnector>> VOICE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VoiceConnectors").getter(ListVoiceConnectorsResponse.getter(ListVoiceConnectorsResponse::voiceConnectors)).setter(ListVoiceConnectorsResponse.setter(Builder::voiceConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoiceConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVoiceConnectorsResponse.getter(ListVoiceConnectorsResponse::nextToken)).setter(ListVoiceConnectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<VoiceConnector> voiceConnectors;
    private final String nextToken;

    private ListVoiceConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnectors = builder.voiceConnectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVoiceConnectors() {
        return this.voiceConnectors != null && !(this.voiceConnectors instanceof SdkAutoConstructList);
    }

    public final List<VoiceConnector> voiceConnectors() {
        return this.voiceConnectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoiceConnectors() ? this.voiceConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceConnectorsResponse)) {
            return false;
        }
        ListVoiceConnectorsResponse other = (ListVoiceConnectorsResponse)((Object)obj);
        return this.hasVoiceConnectors() == other.hasVoiceConnectors() && Objects.equals(this.voiceConnectors(), other.voiceConnectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVoiceConnectorsResponse").add("VoiceConnectors", this.hasVoiceConnectors() ? this.voiceConnectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectors": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceConnectorsResponse, T> g) {
        return obj -> g.apply((ListVoiceConnectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<VoiceConnector> voiceConnectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceConnectorsResponse model) {
            super(model);
            this.voiceConnectors(model.voiceConnectors);
            this.nextToken(model.nextToken);
        }

        public final List<VoiceConnector.Builder> getVoiceConnectors() {
            List<VoiceConnector.Builder> result = VoiceConnectorListCopier.copyToBuilder(this.voiceConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectors(Collection<VoiceConnector.BuilderImpl> voiceConnectors) {
            this.voiceConnectors = VoiceConnectorListCopier.copyFromBuilder(voiceConnectors);
        }

        @Override
        @Transient
        public final Builder voiceConnectors(Collection<VoiceConnector> voiceConnectors) {
            this.voiceConnectors = VoiceConnectorListCopier.copy(voiceConnectors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder voiceConnectors(VoiceConnector ... voiceConnectors) {
            this.voiceConnectors(Arrays.asList(voiceConnectors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder voiceConnectors(Consumer<VoiceConnector.Builder> ... voiceConnectors) {
            this.voiceConnectors(Stream.of(voiceConnectors).map(c -> (VoiceConnector)((VoiceConnector.Builder)VoiceConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVoiceConnectorsResponse build() {
            return new ListVoiceConnectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVoiceConnectorsResponse> {
        public Builder voiceConnectors(Collection<VoiceConnector> var1);

        public Builder voiceConnectors(VoiceConnector ... var1);

        public Builder voiceConnectors(Consumer<VoiceConnector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

