/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AppInstanceListCopier;
import software.amazon.awssdk.services.chime.model.AppInstanceSummary;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppInstancesResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListAppInstancesResponse> {
    private static final SdkField<List<AppInstanceSummary>> APP_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppInstances").getter(ListAppInstancesResponse.getter(ListAppInstancesResponse::appInstances)).setter(ListAppInstancesResponse.setter(Builder::appInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppInstancesResponse.getter(ListAppInstancesResponse::nextToken)).setter(ListAppInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppInstanceSummary> appInstances;
    private final String nextToken;

    private ListAppInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.appInstances = builder.appInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppInstances() {
        return this.appInstances != null && !(this.appInstances instanceof SdkAutoConstructList);
    }

    public final List<AppInstanceSummary> appInstances() {
        return this.appInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInstances() ? this.appInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstancesResponse)) {
            return false;
        }
        ListAppInstancesResponse other = (ListAppInstancesResponse)((Object)obj);
        return this.hasAppInstances() == other.hasAppInstances() && Objects.equals(this.appInstances(), other.appInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppInstancesResponse").add("AppInstances", this.hasAppInstances() ? this.appInstances() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstances": {
                return Optional.ofNullable(clazz.cast(this.appInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstancesResponse, T> g) {
        return obj -> g.apply((ListAppInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<AppInstanceSummary> appInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstancesResponse model) {
            super(model);
            this.appInstances(model.appInstances);
            this.nextToken(model.nextToken);
        }

        public final List<AppInstanceSummary.Builder> getAppInstances() {
            List<AppInstanceSummary.Builder> result = AppInstanceListCopier.copyToBuilder(this.appInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstances(Collection<AppInstanceSummary.BuilderImpl> appInstances) {
            this.appInstances = AppInstanceListCopier.copyFromBuilder(appInstances);
        }

        @Override
        @Transient
        public final Builder appInstances(Collection<AppInstanceSummary> appInstances) {
            this.appInstances = AppInstanceListCopier.copy(appInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstances(AppInstanceSummary ... appInstances) {
            this.appInstances(Arrays.asList(appInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appInstances(Consumer<AppInstanceSummary.Builder> ... appInstances) {
            this.appInstances(Stream.of(appInstances).map(c -> (AppInstanceSummary)((AppInstanceSummary.Builder)AppInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstancesResponse build() {
            return new ListAppInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppInstancesResponse> {
        public Builder appInstances(Collection<AppInstanceSummary> var1);

        public Builder appInstances(AppInstanceSummary ... var1);

        public Builder appInstances(Consumer<AppInstanceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

