/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesRequest;
import software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesResponse;

public class ListMediaCapturePipelinesIterable
implements SdkIterable<ListMediaCapturePipelinesResponse> {
    private final ChimeClient client;
    private final ListMediaCapturePipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMediaCapturePipelinesIterable(ChimeClient client, ListMediaCapturePipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMediaCapturePipelinesResponseFetcher();
    }

    public Iterator<ListMediaCapturePipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMediaCapturePipelinesResponseFetcher
    implements SyncPageFetcher<ListMediaCapturePipelinesResponse> {
        private ListMediaCapturePipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaCapturePipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMediaCapturePipelinesResponse nextPage(ListMediaCapturePipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListMediaCapturePipelinesIterable.this.client.listMediaCapturePipelines(ListMediaCapturePipelinesIterable.this.firstRequest);
            }
            return ListMediaCapturePipelinesIterable.this.client.listMediaCapturePipelines((ListMediaCapturePipelinesRequest)((Object)ListMediaCapturePipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

