/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPlacement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPlacement> {
    private static final SdkField<String> AUDIO_HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioHostUrl").getter(MediaPlacement.getter(MediaPlacement::audioHostUrl)).setter(MediaPlacement.setter(Builder::audioHostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioHostUrl").build()}).build();
    private static final SdkField<String> AUDIO_FALLBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioFallbackUrl").getter(MediaPlacement.getter(MediaPlacement::audioFallbackUrl)).setter(MediaPlacement.setter(Builder::audioFallbackUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioFallbackUrl").build()}).build();
    private static final SdkField<String> SCREEN_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScreenDataUrl").getter(MediaPlacement.getter(MediaPlacement::screenDataUrl)).setter(MediaPlacement.setter(Builder::screenDataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenDataUrl").build()}).build();
    private static final SdkField<String> SCREEN_SHARING_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScreenSharingUrl").getter(MediaPlacement.getter(MediaPlacement::screenSharingUrl)).setter(MediaPlacement.setter(Builder::screenSharingUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenSharingUrl").build()}).build();
    private static final SdkField<String> SCREEN_VIEWING_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScreenViewingUrl").getter(MediaPlacement.getter(MediaPlacement::screenViewingUrl)).setter(MediaPlacement.setter(Builder::screenViewingUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenViewingUrl").build()}).build();
    private static final SdkField<String> SIGNALING_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalingUrl").getter(MediaPlacement.getter(MediaPlacement::signalingUrl)).setter(MediaPlacement.setter(Builder::signalingUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalingUrl").build()}).build();
    private static final SdkField<String> TURN_CONTROL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TurnControlUrl").getter(MediaPlacement.getter(MediaPlacement::turnControlUrl)).setter(MediaPlacement.setter(Builder::turnControlUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnControlUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_HOST_URL_FIELD, AUDIO_FALLBACK_URL_FIELD, SCREEN_DATA_URL_FIELD, SCREEN_SHARING_URL_FIELD, SCREEN_VIEWING_URL_FIELD, SIGNALING_URL_FIELD, TURN_CONTROL_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioHostUrl;
    private final String audioFallbackUrl;
    private final String screenDataUrl;
    private final String screenSharingUrl;
    private final String screenViewingUrl;
    private final String signalingUrl;
    private final String turnControlUrl;

    private MediaPlacement(BuilderImpl builder) {
        this.audioHostUrl = builder.audioHostUrl;
        this.audioFallbackUrl = builder.audioFallbackUrl;
        this.screenDataUrl = builder.screenDataUrl;
        this.screenSharingUrl = builder.screenSharingUrl;
        this.screenViewingUrl = builder.screenViewingUrl;
        this.signalingUrl = builder.signalingUrl;
        this.turnControlUrl = builder.turnControlUrl;
    }

    public final String audioHostUrl() {
        return this.audioHostUrl;
    }

    public final String audioFallbackUrl() {
        return this.audioFallbackUrl;
    }

    public final String screenDataUrl() {
        return this.screenDataUrl;
    }

    public final String screenSharingUrl() {
        return this.screenSharingUrl;
    }

    public final String screenViewingUrl() {
        return this.screenViewingUrl;
    }

    public final String signalingUrl() {
        return this.signalingUrl;
    }

    public final String turnControlUrl() {
        return this.turnControlUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioHostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFallbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenSharingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenViewingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.turnControlUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPlacement)) {
            return false;
        }
        MediaPlacement other = (MediaPlacement)obj;
        return Objects.equals(this.audioHostUrl(), other.audioHostUrl()) && Objects.equals(this.audioFallbackUrl(), other.audioFallbackUrl()) && Objects.equals(this.screenDataUrl(), other.screenDataUrl()) && Objects.equals(this.screenSharingUrl(), other.screenSharingUrl()) && Objects.equals(this.screenViewingUrl(), other.screenViewingUrl()) && Objects.equals(this.signalingUrl(), other.signalingUrl()) && Objects.equals(this.turnControlUrl(), other.turnControlUrl());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPlacement").add("AudioHostUrl", (Object)this.audioHostUrl()).add("AudioFallbackUrl", (Object)this.audioFallbackUrl()).add("ScreenDataUrl", (Object)this.screenDataUrl()).add("ScreenSharingUrl", (Object)this.screenSharingUrl()).add("ScreenViewingUrl", (Object)this.screenViewingUrl()).add("SignalingUrl", (Object)this.signalingUrl()).add("TurnControlUrl", (Object)this.turnControlUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioHostUrl": {
                return Optional.ofNullable(clazz.cast(this.audioHostUrl()));
            }
            case "AudioFallbackUrl": {
                return Optional.ofNullable(clazz.cast(this.audioFallbackUrl()));
            }
            case "ScreenDataUrl": {
                return Optional.ofNullable(clazz.cast(this.screenDataUrl()));
            }
            case "ScreenSharingUrl": {
                return Optional.ofNullable(clazz.cast(this.screenSharingUrl()));
            }
            case "ScreenViewingUrl": {
                return Optional.ofNullable(clazz.cast(this.screenViewingUrl()));
            }
            case "SignalingUrl": {
                return Optional.ofNullable(clazz.cast(this.signalingUrl()));
            }
            case "TurnControlUrl": {
                return Optional.ofNullable(clazz.cast(this.turnControlUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaPlacement, T> g) {
        return obj -> g.apply((MediaPlacement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioHostUrl;
        private String audioFallbackUrl;
        private String screenDataUrl;
        private String screenSharingUrl;
        private String screenViewingUrl;
        private String signalingUrl;
        private String turnControlUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPlacement model) {
            this.audioHostUrl(model.audioHostUrl);
            this.audioFallbackUrl(model.audioFallbackUrl);
            this.screenDataUrl(model.screenDataUrl);
            this.screenSharingUrl(model.screenSharingUrl);
            this.screenViewingUrl(model.screenViewingUrl);
            this.signalingUrl(model.signalingUrl);
            this.turnControlUrl(model.turnControlUrl);
        }

        public final String getAudioHostUrl() {
            return this.audioHostUrl;
        }

        @Override
        public final Builder audioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
            return this;
        }

        public final void setAudioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
        }

        public final String getAudioFallbackUrl() {
            return this.audioFallbackUrl;
        }

        @Override
        public final Builder audioFallbackUrl(String audioFallbackUrl) {
            this.audioFallbackUrl = audioFallbackUrl;
            return this;
        }

        public final void setAudioFallbackUrl(String audioFallbackUrl) {
            this.audioFallbackUrl = audioFallbackUrl;
        }

        public final String getScreenDataUrl() {
            return this.screenDataUrl;
        }

        @Override
        public final Builder screenDataUrl(String screenDataUrl) {
            this.screenDataUrl = screenDataUrl;
            return this;
        }

        public final void setScreenDataUrl(String screenDataUrl) {
            this.screenDataUrl = screenDataUrl;
        }

        public final String getScreenSharingUrl() {
            return this.screenSharingUrl;
        }

        @Override
        public final Builder screenSharingUrl(String screenSharingUrl) {
            this.screenSharingUrl = screenSharingUrl;
            return this;
        }

        public final void setScreenSharingUrl(String screenSharingUrl) {
            this.screenSharingUrl = screenSharingUrl;
        }

        public final String getScreenViewingUrl() {
            return this.screenViewingUrl;
        }

        @Override
        public final Builder screenViewingUrl(String screenViewingUrl) {
            this.screenViewingUrl = screenViewingUrl;
            return this;
        }

        public final void setScreenViewingUrl(String screenViewingUrl) {
            this.screenViewingUrl = screenViewingUrl;
        }

        public final String getSignalingUrl() {
            return this.signalingUrl;
        }

        @Override
        public final Builder signalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
            return this;
        }

        public final void setSignalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
        }

        public final String getTurnControlUrl() {
            return this.turnControlUrl;
        }

        @Override
        public final Builder turnControlUrl(String turnControlUrl) {
            this.turnControlUrl = turnControlUrl;
            return this;
        }

        public final void setTurnControlUrl(String turnControlUrl) {
            this.turnControlUrl = turnControlUrl;
        }

        public MediaPlacement build() {
            return new MediaPlacement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPlacement> {
        public Builder audioHostUrl(String var1);

        public Builder audioFallbackUrl(String var1);

        public Builder screenDataUrl(String var1);

        public Builder screenSharingUrl(String var1);

        public Builder screenViewingUrl(String var1);

        public Builder signalingUrl(String var1);

        public Builder turnControlUrl(String var1);
    }
}

