/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.AccessDeniedException;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserResponse;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse;
import software.amazon.awssdk.services.chime.model.BadRequestException;
import software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest;
import software.amazon.awssdk.services.chime.model.BatchCreateAttendeeResponse;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse;
import software.amazon.awssdk.services.chime.model.ChimeException;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.ConflictException;
import software.amazon.awssdk.services.chime.model.CreateAccountRequest;
import software.amazon.awssdk.services.chime.model.CreateAccountResponse;
import software.amazon.awssdk.services.chime.model.CreateAttendeeRequest;
import software.amazon.awssdk.services.chime.model.CreateAttendeeResponse;
import software.amazon.awssdk.services.chime.model.CreateBotRequest;
import software.amazon.awssdk.services.chime.model.CreateBotResponse;
import software.amazon.awssdk.services.chime.model.CreateMeetingRequest;
import software.amazon.awssdk.services.chime.model.CreateMeetingResponse;
import software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest;
import software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.CreateProxySessionRequest;
import software.amazon.awssdk.services.chime.model.CreateProxySessionResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomResponse;
import software.amazon.awssdk.services.chime.model.CreateUserRequest;
import software.amazon.awssdk.services.chime.model.CreateUserResponse;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DeleteAccountRequest;
import software.amazon.awssdk.services.chime.model.DeleteAccountResponse;
import software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest;
import software.amazon.awssdk.services.chime.model.DeleteAttendeeResponse;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeleteMeetingRequest;
import software.amazon.awssdk.services.chime.model.DeleteMeetingResponse;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.DeleteProxySessionRequest;
import software.amazon.awssdk.services.chime.model.DeleteProxySessionResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse;
import software.amazon.awssdk.services.chime.model.ForbiddenException;
import software.amazon.awssdk.services.chime.model.GetAccountRequest;
import software.amazon.awssdk.services.chime.model.GetAccountResponse;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetAttendeeRequest;
import software.amazon.awssdk.services.chime.model.GetAttendeeResponse;
import software.amazon.awssdk.services.chime.model.GetBotRequest;
import software.amazon.awssdk.services.chime.model.GetBotResponse;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetMeetingRequest;
import software.amazon.awssdk.services.chime.model.GetMeetingResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetProxySessionRequest;
import software.amazon.awssdk.services.chime.model.GetProxySessionResponse;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetRoomRequest;
import software.amazon.awssdk.services.chime.model.GetRoomResponse;
import software.amazon.awssdk.services.chime.model.GetUserRequest;
import software.amazon.awssdk.services.chime.model.GetUserResponse;
import software.amazon.awssdk.services.chime.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.InviteUsersRequest;
import software.amazon.awssdk.services.chime.model.InviteUsersResponse;
import software.amazon.awssdk.services.chime.model.ListAccountsRequest;
import software.amazon.awssdk.services.chime.model.ListAccountsResponse;
import software.amazon.awssdk.services.chime.model.ListAttendeeTagsRequest;
import software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse;
import software.amazon.awssdk.services.chime.model.ListAttendeesRequest;
import software.amazon.awssdk.services.chime.model.ListAttendeesResponse;
import software.amazon.awssdk.services.chime.model.ListBotsRequest;
import software.amazon.awssdk.services.chime.model.ListBotsResponse;
import software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingTagsResponse;
import software.amazon.awssdk.services.chime.model.ListMeetingsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingsResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chime.model.ListProxySessionsResponse;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse;
import software.amazon.awssdk.services.chime.model.ListRoomsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomsResponse;
import software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chime.model.ListUsersRequest;
import software.amazon.awssdk.services.chime.model.ListUsersResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse;
import software.amazon.awssdk.services.chime.model.LogoutUserRequest;
import software.amazon.awssdk.services.chime.model.LogoutUserResponse;
import software.amazon.awssdk.services.chime.model.NotFoundException;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageResponse;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageResponse;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenResponse;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse;
import software.amazon.awssdk.services.chime.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.ServiceFailureException;
import software.amazon.awssdk.services.chime.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chime.model.TagAttendeeRequest;
import software.amazon.awssdk.services.chime.model.TagAttendeeResponse;
import software.amazon.awssdk.services.chime.model.TagMeetingRequest;
import software.amazon.awssdk.services.chime.model.TagMeetingResponse;
import software.amazon.awssdk.services.chime.model.TagResourceRequest;
import software.amazon.awssdk.services.chime.model.TagResourceResponse;
import software.amazon.awssdk.services.chime.model.ThrottledClientException;
import software.amazon.awssdk.services.chime.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chime.model.UnprocessableEntityException;
import software.amazon.awssdk.services.chime.model.UntagAttendeeRequest;
import software.amazon.awssdk.services.chime.model.UntagAttendeeResponse;
import software.amazon.awssdk.services.chime.model.UntagMeetingRequest;
import software.amazon.awssdk.services.chime.model.UntagMeetingResponse;
import software.amazon.awssdk.services.chime.model.UntagResourceRequest;
import software.amazon.awssdk.services.chime.model.UntagResourceResponse;
import software.amazon.awssdk.services.chime.model.UpdateAccountRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountResponse;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateBotRequest;
import software.amazon.awssdk.services.chime.model.UpdateBotResponse;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest;
import software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher;
import software.amazon.awssdk.services.chime.paginators.ListBotsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher;
import software.amazon.awssdk.services.chime.transform.AssociatePhoneNumberWithUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.AssociatePhoneNumbersWithVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.AssociatePhoneNumbersWithVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.AssociateSigninDelegateGroupsWithAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchCreateAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchCreateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchDeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchSuspendUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUnsuspendUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.BatchUpdateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateMeetingRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateMeetingWithAttendeesRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreatePhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.CreateVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteMeetingRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DeleteVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociatePhoneNumberFromUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociatePhoneNumbersFromVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociatePhoneNumbersFromVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.DisassociateSigninDelegateGroupsFromAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetMeetingRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetPhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorTerminationHealthRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.GetVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.InviteUsersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListAttendeeTagsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListAttendeesRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListMeetingTagsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListMeetingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListPhoneNumberOrdersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListProxySessionsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListRoomMembershipsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListRoomsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListVoiceConnectorGroupsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ListVoiceConnectorsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.LogoutUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutEventsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.PutVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RedactConversationMessageRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RedactRoomMessageRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RegenerateSecurityTokenRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.ResetPersonalPinRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.RestorePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.SearchAvailablePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.TagAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.TagMeetingRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UntagAttendeeRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UntagMeetingRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdatePhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateRoomMembershipRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateRoomRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chime.transform.UpdateVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultChimeAsyncClient
implements ChimeAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultChimeAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "chime";
    }

    @Override
    public CompletableFuture<AssociatePhoneNumberWithUserResponse> associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest associatePhoneNumberWithUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, associatePhoneNumberWithUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePhoneNumberWithUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePhoneNumberWithUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePhoneNumberWithUser").withMarshaller((Marshaller)new AssociatePhoneNumberWithUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associatePhoneNumberWithUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associatePhoneNumberWithUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$associatePhoneNumberWithUser$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$associatePhoneNumberWithUser$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest associatePhoneNumbersWithVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, associatePhoneNumbersWithVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePhoneNumbersWithVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePhoneNumbersWithVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePhoneNumbersWithVoiceConnector").withMarshaller((Marshaller)new AssociatePhoneNumbersWithVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associatePhoneNumbersWithVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associatePhoneNumbersWithVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$associatePhoneNumbersWithVoiceConnector$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$associatePhoneNumbersWithVoiceConnector$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(AssociatePhoneNumbersWithVoiceConnectorGroupRequest associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, associatePhoneNumbersWithVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePhoneNumbersWithVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePhoneNumbersWithVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePhoneNumbersWithVoiceConnectorGroup").withMarshaller((Marshaller)new AssociatePhoneNumbersWithVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associatePhoneNumbersWithVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associatePhoneNumbersWithVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$associatePhoneNumbersWithVoiceConnectorGroup$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$associatePhoneNumbersWithVoiceConnectorGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateSigninDelegateGroupsWithAccountResponse> associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest associateSigninDelegateGroupsWithAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateSigninDelegateGroupsWithAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSigninDelegateGroupsWithAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSigninDelegateGroupsWithAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSigninDelegateGroupsWithAccount").withMarshaller((Marshaller)new AssociateSigninDelegateGroupsWithAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateSigninDelegateGroupsWithAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateSigninDelegateGroupsWithAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$associateSigninDelegateGroupsWithAccount$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$associateSigninDelegateGroupsWithAccount$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchCreateAttendeeResponse> batchCreateAttendee(BatchCreateAttendeeRequest batchCreateAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchCreateAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateAttendee").withMarshaller((Marshaller)new BatchCreateAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCreateAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchCreateAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchCreateAttendee$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchCreateAttendee$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchCreateRoomMembershipResponse> batchCreateRoomMembership(BatchCreateRoomMembershipRequest batchCreateRoomMembershipRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchCreateRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreateRoomMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreateRoomMembershipResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreateRoomMembership").withMarshaller((Marshaller)new BatchCreateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCreateRoomMembershipRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchCreateRoomMembershipRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchCreateRoomMembership$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchCreateRoomMembership$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(BatchDeletePhoneNumberRequest batchDeletePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeletePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeletePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeletePhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeletePhoneNumber").withMarshaller((Marshaller)new BatchDeletePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeletePhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeletePhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchDeletePhoneNumber$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchDeletePhoneNumber$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchSuspendUserResponse> batchSuspendUser(BatchSuspendUserRequest batchSuspendUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchSuspendUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchSuspendUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchSuspendUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchSuspendUser").withMarshaller((Marshaller)new BatchSuspendUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchSuspendUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchSuspendUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchSuspendUser$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchSuspendUser$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchUnsuspendUserResponse> batchUnsuspendUser(BatchUnsuspendUserRequest batchUnsuspendUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchUnsuspendUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUnsuspendUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUnsuspendUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUnsuspendUser").withMarshaller((Marshaller)new BatchUnsuspendUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchUnsuspendUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchUnsuspendUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchUnsuspendUser$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchUnsuspendUser$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest batchUpdatePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchUpdatePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdatePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdatePhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdatePhoneNumber").withMarshaller((Marshaller)new BatchUpdatePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchUpdatePhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchUpdatePhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchUpdatePhoneNumber$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchUpdatePhoneNumber$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchUpdateUserResponse> batchUpdateUser(BatchUpdateUserRequest batchUpdateUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchUpdateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateUser").withMarshaller((Marshaller)new BatchUpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchUpdateUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchUpdateUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$batchUpdateUser$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$batchUpdateUser$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAccountResponse> createAccount(CreateAccountRequest createAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccount").withMarshaller((Marshaller)new CreateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createAccount$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createAccount$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAttendeeResponse> createAttendee(CreateAttendeeRequest createAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAttendee").withMarshaller((Marshaller)new CreateAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createAttendee$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createAttendee$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBot").withMarshaller((Marshaller)new CreateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createBotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createBot$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createBot$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMeetingResponse> createMeeting(CreateMeetingRequest createMeetingRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMeeting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeetingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMeeting").withMarshaller((Marshaller)new CreateMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMeetingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMeetingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createMeeting$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createMeeting$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMeetingWithAttendeesResponse> createMeetingWithAttendees(CreateMeetingWithAttendeesRequest createMeetingWithAttendeesRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMeetingWithAttendeesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMeetingWithAttendees");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeetingWithAttendeesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMeetingWithAttendees").withMarshaller((Marshaller)new CreateMeetingWithAttendeesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMeetingWithAttendeesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMeetingWithAttendeesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createMeetingWithAttendees$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createMeetingWithAttendees$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(CreatePhoneNumberOrderRequest createPhoneNumberOrderRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPhoneNumberOrderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePhoneNumberOrder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePhoneNumberOrderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePhoneNumberOrder").withMarshaller((Marshaller)new CreatePhoneNumberOrderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPhoneNumberOrderRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPhoneNumberOrderRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createPhoneNumberOrder$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createPhoneNumberOrder$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateProxySessionResponse> createProxySession(CreateProxySessionRequest createProxySessionRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createProxySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProxySessionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProxySession").withMarshaller((Marshaller)new CreateProxySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createProxySessionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createProxySessionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createProxySession$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createProxySession$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRoomResponse> createRoom(CreateRoomRequest createRoomRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoom");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRoomResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoom").withMarshaller((Marshaller)new CreateRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRoomRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRoomRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createRoom$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createRoom$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRoomMembershipResponse> createRoomMembership(CreateRoomMembershipRequest createRoomMembershipRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoomMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRoomMembershipResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoomMembership").withMarshaller((Marshaller)new CreateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRoomMembershipRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRoomMembershipRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createRoomMembership$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createRoomMembership$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createUser$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createUser$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(CreateVoiceConnectorRequest createVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVoiceConnector").withMarshaller((Marshaller)new CreateVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createVoiceConnector$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createVoiceConnector$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest createVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVoiceConnectorGroup").withMarshaller((Marshaller)new CreateVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$createVoiceConnectorGroup$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$createVoiceConnectorGroup$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccountResponse> deleteAccount(DeleteAccountRequest deleteAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccount").withMarshaller((Marshaller)new DeleteAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteAccount$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteAccount$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAttendeeResponse> deleteAttendee(DeleteAttendeeRequest deleteAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAttendee").withMarshaller((Marshaller)new DeleteAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteAttendee$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteAttendee$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventsConfigurationResponse> deleteEventsConfiguration(DeleteEventsConfigurationRequest deleteEventsConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventsConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventsConfiguration").withMarshaller((Marshaller)new DeleteEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEventsConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEventsConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteEventsConfiguration$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteEventsConfiguration$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMeetingResponse> deleteMeeting(DeleteMeetingRequest deleteMeetingRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMeeting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMeetingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMeeting").withMarshaller((Marshaller)new DeleteMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMeetingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMeetingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteMeeting$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteMeeting$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(DeletePhoneNumberRequest deletePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePhoneNumber").withMarshaller((Marshaller)new DeletePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deletePhoneNumber$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deletePhoneNumber$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteProxySessionResponse> deleteProxySession(DeleteProxySessionRequest deleteProxySessionRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteProxySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProxySessionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProxySession").withMarshaller((Marshaller)new DeleteProxySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteProxySessionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteProxySessionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteProxySession$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteProxySession$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRoomResponse> deleteRoom(DeleteRoomRequest deleteRoomRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoom");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRoomResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoom").withMarshaller((Marshaller)new DeleteRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRoomRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRoomRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteRoom$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteRoom$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRoomMembershipResponse> deleteRoomMembership(DeleteRoomMembershipRequest deleteRoomMembershipRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoomMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRoomMembershipResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoomMembership").withMarshaller((Marshaller)new DeleteRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRoomMembershipRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRoomMembershipRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteRoomMembership$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteRoomMembership$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(DeleteVoiceConnectorRequest deleteVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnector").withMarshaller((Marshaller)new DeleteVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnector$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnector$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> deleteVoiceConnectorEmergencyCallingConfiguration(DeleteVoiceConnectorEmergencyCallingConfigurationRequest deleteVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorEmergencyCallingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorEmergencyCallingConfiguration").withMarshaller((Marshaller)new DeleteVoiceConnectorEmergencyCallingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorEmergencyCallingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorEmergencyCallingConfiguration$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorEmergencyCallingConfiguration$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest deleteVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorGroup").withMarshaller((Marshaller)new DeleteVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorGroup$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorGroup$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest deleteVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorOriginationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorOrigination").withMarshaller((Marshaller)new DeleteVoiceConnectorOriginationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorOriginationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorOrigination$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorOrigination$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest deleteVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorProxyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorProxyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorProxy").withMarshaller((Marshaller)new DeleteVoiceConnectorProxyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorProxyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorProxyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorProxy$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorProxy$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest deleteVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorStreamingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorStreamingConfiguration").withMarshaller((Marshaller)new DeleteVoiceConnectorStreamingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorStreamingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorStreamingConfiguration$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorStreamingConfiguration$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest deleteVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorTerminationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorTermination").withMarshaller((Marshaller)new DeleteVoiceConnectorTerminationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorTerminationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorTermination$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorTermination$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest deleteVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceConnectorTerminationCredentialsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceConnectorTerminationCredentials").withMarshaller((Marshaller)new DeleteVoiceConnectorTerminationCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceConnectorTerminationCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorTerminationCredentials$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$deleteVoiceConnectorTerminationCredentials$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociatePhoneNumberFromUserResponse> disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest disassociatePhoneNumberFromUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociatePhoneNumberFromUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePhoneNumberFromUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePhoneNumberFromUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePhoneNumberFromUser").withMarshaller((Marshaller)new DisassociatePhoneNumberFromUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociatePhoneNumberFromUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociatePhoneNumberFromUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumberFromUser$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumberFromUser$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest disassociatePhoneNumbersFromVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociatePhoneNumbersFromVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePhoneNumbersFromVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePhoneNumbersFromVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePhoneNumbersFromVoiceConnector").withMarshaller((Marshaller)new DisassociatePhoneNumbersFromVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociatePhoneNumbersFromVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociatePhoneNumbersFromVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumbersFromVoiceConnector$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumbersFromVoiceConnector$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociatePhoneNumbersFromVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePhoneNumbersFromVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePhoneNumbersFromVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePhoneNumbersFromVoiceConnectorGroup").withMarshaller((Marshaller)new DisassociatePhoneNumbersFromVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociatePhoneNumbersFromVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociatePhoneNumbersFromVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumbersFromVoiceConnectorGroup$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$disassociatePhoneNumbersFromVoiceConnectorGroup$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateSigninDelegateGroupsFromAccountResponse> disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest disassociateSigninDelegateGroupsFromAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateSigninDelegateGroupsFromAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSigninDelegateGroupsFromAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSigninDelegateGroupsFromAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSigninDelegateGroupsFromAccount").withMarshaller((Marshaller)new DisassociateSigninDelegateGroupsFromAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateSigninDelegateGroupsFromAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateSigninDelegateGroupsFromAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$disassociateSigninDelegateGroupsFromAccount$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$disassociateSigninDelegateGroupsFromAccount$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getAccount$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getAccount$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountSettings").withMarshaller((Marshaller)new GetAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccountSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAccountSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getAccountSettings$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getAccountSettings$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAttendeeResponse> getAttendee(GetAttendeeRequest getAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAttendee").withMarshaller((Marshaller)new GetAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getAttendee$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getAttendee$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBotResponse> getBot(GetBotRequest getBotRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBot").withMarshaller((Marshaller)new GetBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getBot$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getBot$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventsConfigurationResponse> getEventsConfiguration(GetEventsConfigurationRequest getEventsConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventsConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventsConfiguration").withMarshaller((Marshaller)new GetEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventsConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getEventsConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getEventsConfiguration$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getEventsConfiguration$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(GetGlobalSettingsRequest getGlobalSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getGlobalSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGlobalSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGlobalSettings").withMarshaller((Marshaller)new GetGlobalSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getGlobalSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getGlobalSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getGlobalSettings$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getGlobalSettings$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMeetingResponse> getMeeting(GetMeetingRequest getMeetingRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMeeting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMeetingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMeeting").withMarshaller((Marshaller)new GetMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMeetingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMeetingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getMeeting$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getMeeting$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(GetPhoneNumberRequest getPhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumber").withMarshaller((Marshaller)new GetPhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getPhoneNumber$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getPhoneNumber$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(GetPhoneNumberOrderRequest getPhoneNumberOrderRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPhoneNumberOrderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumberOrder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberOrderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumberOrder").withMarshaller((Marshaller)new GetPhoneNumberOrderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPhoneNumberOrderRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPhoneNumberOrderRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getPhoneNumberOrder$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getPhoneNumberOrder$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(GetPhoneNumberSettingsRequest getPhoneNumberSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPhoneNumberSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPhoneNumberSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPhoneNumberSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPhoneNumberSettings").withMarshaller((Marshaller)new GetPhoneNumberSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPhoneNumberSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPhoneNumberSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getPhoneNumberSettings$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getPhoneNumberSettings$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetProxySessionResponse> getProxySession(GetProxySessionRequest getProxySessionRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getProxySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProxySessionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProxySession").withMarshaller((Marshaller)new GetProxySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getProxySessionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getProxySessionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getProxySession$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getProxySession$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRetentionSettingsResponse> getRetentionSettings(GetRetentionSettingsRequest getRetentionSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRetentionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRetentionSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRetentionSettings").withMarshaller((Marshaller)new GetRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRetentionSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRetentionSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getRetentionSettings$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getRetentionSettings$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRoomResponse> getRoom(GetRoomRequest getRoomRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRoom");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRoomResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRoom").withMarshaller((Marshaller)new GetRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRoomRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRoomRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getRoom$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getRoom$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUser").withMarshaller((Marshaller)new GetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getUser$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getUser$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserSettingsResponse> getUserSettings(GetUserSettingsRequest getUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserSettings").withMarshaller((Marshaller)new GetUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUserSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getUserSettings$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getUserSettings$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(GetVoiceConnectorRequest getVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnector").withMarshaller((Marshaller)new GetVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnector$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnector$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> getVoiceConnectorEmergencyCallingConfiguration(GetVoiceConnectorEmergencyCallingConfigurationRequest getVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorEmergencyCallingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorEmergencyCallingConfiguration").withMarshaller((Marshaller)new GetVoiceConnectorEmergencyCallingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorEmergencyCallingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorEmergencyCallingConfiguration$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorEmergencyCallingConfiguration$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(GetVoiceConnectorGroupRequest getVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorGroup").withMarshaller((Marshaller)new GetVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorGroup$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorGroup$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest getVoiceConnectorLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorLoggingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorLoggingConfiguration").withMarshaller((Marshaller)new GetVoiceConnectorLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorLoggingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorLoggingConfiguration$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorLoggingConfiguration$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest getVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorOriginationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorOrigination").withMarshaller((Marshaller)new GetVoiceConnectorOriginationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorOriginationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorOrigination$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorOrigination$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(GetVoiceConnectorProxyRequest getVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorProxyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorProxyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorProxy").withMarshaller((Marshaller)new GetVoiceConnectorProxyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorProxyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorProxyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorProxy$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorProxy$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest getVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorStreamingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorStreamingConfiguration").withMarshaller((Marshaller)new GetVoiceConnectorStreamingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorStreamingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorStreamingConfiguration$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorStreamingConfiguration$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest getVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorTerminationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorTermination").withMarshaller((Marshaller)new GetVoiceConnectorTerminationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorTerminationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorTermination$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorTermination$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest getVoiceConnectorTerminationHealthRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getVoiceConnectorTerminationHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceConnectorTerminationHealth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceConnectorTerminationHealthResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceConnectorTerminationHealth").withMarshaller((Marshaller)new GetVoiceConnectorTerminationHealthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceConnectorTerminationHealthRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceConnectorTerminationHealthRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$getVoiceConnectorTerminationHealth$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$getVoiceConnectorTerminationHealth$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InviteUsersResponse> inviteUsers(InviteUsersRequest inviteUsersRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, inviteUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InviteUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteUsersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteUsers").withMarshaller((Marshaller)new InviteUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)inviteUsersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = inviteUsersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$inviteUsers$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$inviteUsers$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccountsResponse> listAccounts(ListAccountsRequest listAccountsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccounts").withMarshaller((Marshaller)new ListAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAccountsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAccountsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listAccounts$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listAccounts$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAccountsPublisher listAccountsPaginator(ListAccountsRequest listAccountsRequest) {
        return new ListAccountsPublisher(this, this.applyPaginatorUserAgent(listAccountsRequest));
    }

    @Override
    public CompletableFuture<ListAttendeeTagsResponse> listAttendeeTags(ListAttendeeTagsRequest listAttendeeTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAttendeeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttendeeTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttendeeTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttendeeTags").withMarshaller((Marshaller)new ListAttendeeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAttendeeTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAttendeeTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listAttendeeTags$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listAttendeeTags$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAttendeesResponse> listAttendees(ListAttendeesRequest listAttendeesRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAttendeesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttendees");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttendeesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttendees").withMarshaller((Marshaller)new ListAttendeesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAttendeesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAttendeesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listAttendees$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listAttendees$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAttendeesPublisher listAttendeesPaginator(ListAttendeesRequest listAttendeesRequest) {
        return new ListAttendeesPublisher(this, this.applyPaginatorUserAgent(listAttendeesRequest));
    }

    @Override
    public CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listBotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBots").withMarshaller((Marshaller)new ListBotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listBotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listBots$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listBots$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListBotsPublisher listBotsPaginator(ListBotsRequest listBotsRequest) {
        return new ListBotsPublisher(this, this.applyPaginatorUserAgent(listBotsRequest));
    }

    @Override
    public CompletableFuture<ListMeetingTagsResponse> listMeetingTags(ListMeetingTagsRequest listMeetingTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMeetingTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMeetingTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMeetingTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMeetingTags").withMarshaller((Marshaller)new ListMeetingTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMeetingTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMeetingTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listMeetingTags$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listMeetingTags$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMeetingsResponse> listMeetings(ListMeetingsRequest listMeetingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMeetingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMeetings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMeetingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMeetings").withMarshaller((Marshaller)new ListMeetingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMeetingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMeetingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listMeetings$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listMeetings$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMeetingsPublisher listMeetingsPaginator(ListMeetingsRequest listMeetingsRequest) {
        return new ListMeetingsPublisher(this, this.applyPaginatorUserAgent(listMeetingsRequest));
    }

    @Override
    public CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPhoneNumberOrdersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPhoneNumberOrders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhoneNumberOrdersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumberOrders").withMarshaller((Marshaller)new ListPhoneNumberOrdersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPhoneNumberOrdersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPhoneNumberOrdersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listPhoneNumberOrders$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listPhoneNumberOrders$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        return new ListPhoneNumberOrdersPublisher(this, this.applyPaginatorUserAgent(listPhoneNumberOrdersRequest));
    }

    @Override
    public CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPhoneNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPhoneNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhoneNumbersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumbers").withMarshaller((Marshaller)new ListPhoneNumbersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPhoneNumbersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPhoneNumbersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listPhoneNumbers$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listPhoneNumbers$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPhoneNumbersPublisher listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        return new ListPhoneNumbersPublisher(this, this.applyPaginatorUserAgent(listPhoneNumbersRequest));
    }

    @Override
    public CompletableFuture<ListProxySessionsResponse> listProxySessions(ListProxySessionsRequest listProxySessionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listProxySessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProxySessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProxySessionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProxySessions").withMarshaller((Marshaller)new ListProxySessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listProxySessionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listProxySessionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listProxySessions$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listProxySessions$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListProxySessionsPublisher listProxySessionsPaginator(ListProxySessionsRequest listProxySessionsRequest) {
        return new ListProxySessionsPublisher(this, this.applyPaginatorUserAgent(listProxySessionsRequest));
    }

    @Override
    public CompletableFuture<ListRoomMembershipsResponse> listRoomMemberships(ListRoomMembershipsRequest listRoomMembershipsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRoomMembershipsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoomMemberships");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoomMembershipsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoomMemberships").withMarshaller((Marshaller)new ListRoomMembershipsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRoomMembershipsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRoomMembershipsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listRoomMemberships$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listRoomMemberships$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRoomMembershipsPublisher listRoomMembershipsPaginator(ListRoomMembershipsRequest listRoomMembershipsRequest) {
        return new ListRoomMembershipsPublisher(this, this.applyPaginatorUserAgent(listRoomMembershipsRequest));
    }

    @Override
    public CompletableFuture<ListRoomsResponse> listRooms(ListRoomsRequest listRoomsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRoomsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRooms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoomsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRooms").withMarshaller((Marshaller)new ListRoomsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRoomsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRoomsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listRooms$235(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listRooms$236((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRoomsPublisher listRoomsPaginator(ListRoomsRequest listRoomsRequest) {
        return new ListRoomsPublisher(this, this.applyPaginatorUserAgent(listRoomsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listTagsForResource$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listTagsForResource$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listUsersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listUsersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listUsers$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listUsers$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    @Override
    public CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listVoiceConnectorGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVoiceConnectorGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVoiceConnectorGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVoiceConnectorGroups").withMarshaller((Marshaller)new ListVoiceConnectorGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVoiceConnectorGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVoiceConnectorGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listVoiceConnectorGroups$244(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listVoiceConnectorGroups$245((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        return new ListVoiceConnectorGroupsPublisher(this, this.applyPaginatorUserAgent(listVoiceConnectorGroupsRequest));
    }

    @Override
    public CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest listVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVoiceConnectorTerminationCredentialsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVoiceConnectorTerminationCredentials").withMarshaller((Marshaller)new ListVoiceConnectorTerminationCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVoiceConnectorTerminationCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listVoiceConnectorTerminationCredentials$247(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listVoiceConnectorTerminationCredentials$248((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listVoiceConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVoiceConnectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVoiceConnectorsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVoiceConnectors").withMarshaller((Marshaller)new ListVoiceConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVoiceConnectorsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVoiceConnectorsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$listVoiceConnectors$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$listVoiceConnectors$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        return new ListVoiceConnectorsPublisher(this, this.applyPaginatorUserAgent(listVoiceConnectorsRequest));
    }

    @Override
    public CompletableFuture<LogoutUserResponse> logoutUser(LogoutUserRequest logoutUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, logoutUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LogoutUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LogoutUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("LogoutUser").withMarshaller((Marshaller)new LogoutUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)logoutUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = logoutUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$logoutUser$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$logoutUser$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEventsConfigurationResponse> putEventsConfiguration(PutEventsConfigurationRequest putEventsConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putEventsConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEventsConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEventsConfiguration").withMarshaller((Marshaller)new PutEventsConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEventsConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putEventsConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putEventsConfiguration$256(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putEventsConfiguration$257((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRetentionSettingsResponse> putRetentionSettings(PutRetentionSettingsRequest putRetentionSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRetentionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRetentionSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRetentionSettings").withMarshaller((Marshaller)new PutRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRetentionSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putRetentionSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putRetentionSettings$259(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putRetentionSettings$260((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> putVoiceConnectorEmergencyCallingConfiguration(PutVoiceConnectorEmergencyCallingConfigurationRequest putVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorEmergencyCallingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorEmergencyCallingConfiguration").withMarshaller((Marshaller)new PutVoiceConnectorEmergencyCallingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorEmergencyCallingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorEmergencyCallingConfiguration$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorEmergencyCallingConfiguration$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest putVoiceConnectorLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorLoggingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorLoggingConfiguration").withMarshaller((Marshaller)new PutVoiceConnectorLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorLoggingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorLoggingConfiguration$265(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorLoggingConfiguration$266((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest putVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorOriginationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorOrigination").withMarshaller((Marshaller)new PutVoiceConnectorOriginationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorOriginationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorOrigination$268(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorOrigination$269((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(PutVoiceConnectorProxyRequest putVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorProxyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorProxyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorProxy").withMarshaller((Marshaller)new PutVoiceConnectorProxyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorProxyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorProxyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorProxy$271(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorProxy$272((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest putVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorStreamingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorStreamingConfiguration").withMarshaller((Marshaller)new PutVoiceConnectorStreamingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorStreamingConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorStreamingConfiguration$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorStreamingConfiguration$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest putVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorTerminationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorTermination").withMarshaller((Marshaller)new PutVoiceConnectorTerminationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorTerminationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorTermination$277(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorTermination$278((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest putVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, putVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVoiceConnectorTerminationCredentialsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVoiceConnectorTerminationCredentials").withMarshaller((Marshaller)new PutVoiceConnectorTerminationCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putVoiceConnectorTerminationCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$putVoiceConnectorTerminationCredentials$280(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$putVoiceConnectorTerminationCredentials$281((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RedactConversationMessageResponse> redactConversationMessage(RedactConversationMessageRequest redactConversationMessageRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, redactConversationMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedactConversationMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedactConversationMessageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedactConversationMessage").withMarshaller((Marshaller)new RedactConversationMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)redactConversationMessageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = redactConversationMessageRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$redactConversationMessage$283(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$redactConversationMessage$284((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RedactRoomMessageResponse> redactRoomMessage(RedactRoomMessageRequest redactRoomMessageRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, redactRoomMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedactRoomMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedactRoomMessageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedactRoomMessage").withMarshaller((Marshaller)new RedactRoomMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)redactRoomMessageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = redactRoomMessageRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$redactRoomMessage$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$redactRoomMessage$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegenerateSecurityTokenResponse> regenerateSecurityToken(RegenerateSecurityTokenRequest regenerateSecurityTokenRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, regenerateSecurityTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegenerateSecurityToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegenerateSecurityTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegenerateSecurityToken").withMarshaller((Marshaller)new RegenerateSecurityTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)regenerateSecurityTokenRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = regenerateSecurityTokenRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$regenerateSecurityToken$289(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$regenerateSecurityToken$290((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetPersonalPinResponse> resetPersonalPIN(ResetPersonalPinRequest resetPersonalPinRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetPersonalPinRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetPersonalPIN");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetPersonalPinResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetPersonalPIN").withMarshaller((Marshaller)new ResetPersonalPinRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetPersonalPinRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetPersonalPinRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$resetPersonalPIN$292(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$resetPersonalPIN$293((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(RestorePhoneNumberRequest restorePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, restorePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestorePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestorePhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestorePhoneNumber").withMarshaller((Marshaller)new RestorePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restorePhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restorePhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$restorePhoneNumber$295(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$restorePhoneNumber$296((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, searchAvailablePhoneNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchAvailablePhoneNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchAvailablePhoneNumbersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchAvailablePhoneNumbers").withMarshaller((Marshaller)new SearchAvailablePhoneNumbersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchAvailablePhoneNumbersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = searchAvailablePhoneNumbersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$searchAvailablePhoneNumbers$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$searchAvailablePhoneNumbers$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagAttendeeResponse> tagAttendee(TagAttendeeRequest tagAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagAttendee").withMarshaller((Marshaller)new TagAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$tagAttendee$301(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$tagAttendee$302((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagMeetingResponse> tagMeeting(TagMeetingRequest tagMeetingRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagMeeting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagMeetingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagMeeting").withMarshaller((Marshaller)new TagMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagMeetingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagMeetingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$tagMeeting$304(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$tagMeeting$305((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$tagResource$307(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$tagResource$308((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagAttendeeResponse> untagAttendee(UntagAttendeeRequest untagAttendeeRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagAttendeeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagAttendee");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagAttendeeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagAttendee").withMarshaller((Marshaller)new UntagAttendeeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagAttendeeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagAttendeeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$untagAttendee$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$untagAttendee$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagMeetingResponse> untagMeeting(UntagMeetingRequest untagMeetingRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagMeetingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagMeeting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagMeetingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagMeeting").withMarshaller((Marshaller)new UntagMeetingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagMeetingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagMeetingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$untagMeeting$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$untagMeeting$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$untagResource$316(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$untagResource$317((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAccountResponse> updateAccount(UpdateAccountRequest updateAccountRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccount").withMarshaller((Marshaller)new UpdateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAccountRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateAccount$319(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateAccount$320((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSettings").withMarshaller((Marshaller)new UpdateAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAccountSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAccountSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateAccountSettings$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateAccountSettings$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBot").withMarshaller((Marshaller)new UpdateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateBotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateBot$325(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateBot$326((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalSettings").withMarshaller((Marshaller)new UpdateGlobalSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGlobalSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateGlobalSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateGlobalSettings$328(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateGlobalSettings$329((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePhoneNumberResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePhoneNumber").withMarshaller((Marshaller)new UpdatePhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePhoneNumberRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePhoneNumberRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updatePhoneNumber$331(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updatePhoneNumber$332((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest updatePhoneNumberSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePhoneNumberSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePhoneNumberSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePhoneNumberSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePhoneNumberSettings").withMarshaller((Marshaller)new UpdatePhoneNumberSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePhoneNumberSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePhoneNumberSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updatePhoneNumberSettings$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updatePhoneNumberSettings$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateProxySessionResponse> updateProxySession(UpdateProxySessionRequest updateProxySessionRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateProxySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProxySessionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProxySession").withMarshaller((Marshaller)new UpdateProxySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateProxySessionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateProxySessionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateProxySession$337(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateProxySession$338((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRoomResponse> updateRoom(UpdateRoomRequest updateRoomRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRoomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoom");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRoomResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoom").withMarshaller((Marshaller)new UpdateRoomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRoomRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRoomRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateRoom$340(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateRoom$341((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRoomMembershipResponse> updateRoomMembership(UpdateRoomMembershipRequest updateRoomMembershipRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRoomMembershipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoomMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRoomMembershipResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoomMembership").withMarshaller((Marshaller)new UpdateRoomMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRoomMembershipRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRoomMembershipRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateRoomMembership$343(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateRoomMembership$344((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateUserRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateUser$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateUser$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserSettings").withMarshaller((Marshaller)new UpdateUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateUserSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateUserSettings$349(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateUserSettings$350((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(UpdateVoiceConnectorRequest updateVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateVoiceConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVoiceConnectorResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVoiceConnector").withMarshaller((Marshaller)new UpdateVoiceConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVoiceConnectorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVoiceConnectorRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateVoiceConnector$352(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateVoiceConnector$353((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest updateVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultChimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVoiceConnectorGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVoiceConnectorGroup").withMarshaller((Marshaller)new UpdateVoiceConnectorGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVoiceConnectorGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVoiceConnectorGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultChimeAsyncClient.lambda$updateVoiceConnectorGroup$355(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultChimeAsyncClient.lambda$updateVoiceConnectorGroup$356((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ChimeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceFailureException").exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(Integer.valueOf(422)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottledClientException").exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ChimeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.14.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ChimeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$updateVoiceConnectorGroup$356(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVoiceConnectorGroup$355(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateVoiceConnector$353(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVoiceConnector$352(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateUserSettings$350(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserSettings$349(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateUser$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUser$346(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRoomMembership$344(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoomMembership$343(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRoomMembershipResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRoom$341(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoom$340(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRoomResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateProxySession$338(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProxySession$337(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateProxySessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePhoneNumberSettings$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePhoneNumberSettings$334(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePhoneNumberSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePhoneNumber$332(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePhoneNumber$331(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGlobalSettings$329(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalSettings$328(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGlobalSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBot$326(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBot$325(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAccountSettings$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSettings$322(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAccountSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAccount$320(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccount$319(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$317(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$316(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagMeeting$314(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagMeeting$313(List metricPublishers, MetricCollector apiCallMetricCollector, UntagMeetingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagAttendee$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagAttendee$310(List metricPublishers, MetricCollector apiCallMetricCollector, UntagAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$308(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$307(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagMeeting$305(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagMeeting$304(List metricPublishers, MetricCollector apiCallMetricCollector, TagMeetingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagAttendee$302(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagAttendee$301(List metricPublishers, MetricCollector apiCallMetricCollector, TagAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchAvailablePhoneNumbers$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchAvailablePhoneNumbers$298(List metricPublishers, MetricCollector apiCallMetricCollector, SearchAvailablePhoneNumbersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restorePhoneNumber$296(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restorePhoneNumber$295(List metricPublishers, MetricCollector apiCallMetricCollector, RestorePhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetPersonalPIN$293(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetPersonalPIN$292(List metricPublishers, MetricCollector apiCallMetricCollector, ResetPersonalPinResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$regenerateSecurityToken$290(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$regenerateSecurityToken$289(List metricPublishers, MetricCollector apiCallMetricCollector, RegenerateSecurityTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$redactRoomMessage$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redactRoomMessage$286(List metricPublishers, MetricCollector apiCallMetricCollector, RedactRoomMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$redactConversationMessage$284(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redactConversationMessage$283(List metricPublishers, MetricCollector apiCallMetricCollector, RedactConversationMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorTerminationCredentials$281(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorTerminationCredentials$280(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorTerminationCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorTermination$278(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorTermination$277(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorTerminationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorStreamingConfiguration$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorStreamingConfiguration$274(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorStreamingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorProxy$272(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorProxy$271(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorProxyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorOrigination$269(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorOrigination$268(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorOriginationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorLoggingConfiguration$266(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorLoggingConfiguration$265(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putVoiceConnectorEmergencyCallingConfiguration$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVoiceConnectorEmergencyCallingConfiguration$262(List metricPublishers, MetricCollector apiCallMetricCollector, PutVoiceConnectorEmergencyCallingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRetentionSettings$260(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRetentionSettings$259(List metricPublishers, MetricCollector apiCallMetricCollector, PutRetentionSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEventsConfiguration$257(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEventsConfiguration$256(List metricPublishers, MetricCollector apiCallMetricCollector, PutEventsConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$logoutUser$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$logoutUser$253(List metricPublishers, MetricCollector apiCallMetricCollector, LogoutUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVoiceConnectors$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVoiceConnectors$250(List metricPublishers, MetricCollector apiCallMetricCollector, ListVoiceConnectorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVoiceConnectorTerminationCredentials$248(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVoiceConnectorTerminationCredentials$247(List metricPublishers, MetricCollector apiCallMetricCollector, ListVoiceConnectorTerminationCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVoiceConnectorGroups$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVoiceConnectorGroups$244(List metricPublishers, MetricCollector apiCallMetricCollector, ListVoiceConnectorGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listUsers$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$241(List metricPublishers, MetricCollector apiCallMetricCollector, ListUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$238(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRooms$236(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRooms$235(List metricPublishers, MetricCollector apiCallMetricCollector, ListRoomsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRoomMemberships$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoomMemberships$232(List metricPublishers, MetricCollector apiCallMetricCollector, ListRoomMembershipsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listProxySessions$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProxySessions$229(List metricPublishers, MetricCollector apiCallMetricCollector, ListProxySessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPhoneNumbers$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPhoneNumbers$226(List metricPublishers, MetricCollector apiCallMetricCollector, ListPhoneNumbersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPhoneNumberOrders$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPhoneNumberOrders$223(List metricPublishers, MetricCollector apiCallMetricCollector, ListPhoneNumberOrdersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMeetings$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMeetings$220(List metricPublishers, MetricCollector apiCallMetricCollector, ListMeetingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMeetingTags$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMeetingTags$217(List metricPublishers, MetricCollector apiCallMetricCollector, ListMeetingTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBots$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBots$214(List metricPublishers, MetricCollector apiCallMetricCollector, ListBotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAttendees$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttendees$211(List metricPublishers, MetricCollector apiCallMetricCollector, ListAttendeesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAttendeeTags$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttendeeTags$208(List metricPublishers, MetricCollector apiCallMetricCollector, ListAttendeeTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccounts$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccounts$205(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccountsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$inviteUsers$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inviteUsers$202(List metricPublishers, MetricCollector apiCallMetricCollector, InviteUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorTerminationHealth$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorTerminationHealth$199(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorTerminationHealthResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorTermination$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorTermination$196(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorTerminationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorStreamingConfiguration$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorStreamingConfiguration$193(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorStreamingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorProxy$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorProxy$190(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorProxyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorOrigination$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorOrigination$187(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorOriginationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorLoggingConfiguration$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorLoggingConfiguration$184(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorGroup$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorGroup$181(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnectorEmergencyCallingConfiguration$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnectorEmergencyCallingConfiguration$178(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorEmergencyCallingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceConnector$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceConnector$175(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUserSettings$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserSettings$172(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUser$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUser$169(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRoom$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRoom$166(List metricPublishers, MetricCollector apiCallMetricCollector, GetRoomResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRetentionSettings$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRetentionSettings$163(List metricPublishers, MetricCollector apiCallMetricCollector, GetRetentionSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getProxySession$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProxySession$160(List metricPublishers, MetricCollector apiCallMetricCollector, GetProxySessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPhoneNumberSettings$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumberSettings$157(List metricPublishers, MetricCollector apiCallMetricCollector, GetPhoneNumberSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPhoneNumberOrder$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumberOrder$154(List metricPublishers, MetricCollector apiCallMetricCollector, GetPhoneNumberOrderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPhoneNumber$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPhoneNumber$151(List metricPublishers, MetricCollector apiCallMetricCollector, GetPhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMeeting$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMeeting$148(List metricPublishers, MetricCollector apiCallMetricCollector, GetMeetingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGlobalSettings$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGlobalSettings$145(List metricPublishers, MetricCollector apiCallMetricCollector, GetGlobalSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEventsConfiguration$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventsConfiguration$142(List metricPublishers, MetricCollector apiCallMetricCollector, GetEventsConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBot$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBot$139(List metricPublishers, MetricCollector apiCallMetricCollector, GetBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAttendee$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAttendee$136(List metricPublishers, MetricCollector apiCallMetricCollector, GetAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccountSettings$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountSettings$133(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccount$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccount$130(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateSigninDelegateGroupsFromAccount$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSigninDelegateGroupsFromAccount$127(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateSigninDelegateGroupsFromAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumbersFromVoiceConnectorGroup$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumbersFromVoiceConnectorGroup$124(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociatePhoneNumbersFromVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumbersFromVoiceConnector$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumbersFromVoiceConnector$121(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociatePhoneNumbersFromVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumberFromUser$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePhoneNumberFromUser$118(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociatePhoneNumberFromUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorTerminationCredentials$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorTerminationCredentials$115(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorTerminationCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorTermination$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorTermination$112(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorTerminationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorStreamingConfiguration$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorStreamingConfiguration$109(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorStreamingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorProxy$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorProxy$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorProxyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorOrigination$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorOrigination$103(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorOriginationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorGroup$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorGroup$100(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorEmergencyCallingConfiguration$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnectorEmergencyCallingConfiguration$97(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorEmergencyCallingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceConnector$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceConnector$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRoomMembership$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoomMembership$91(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRoomMembershipResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRoom$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoom$88(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRoomResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteProxySession$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProxySession$85(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteProxySessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePhoneNumber$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePhoneNumber$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMeeting$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMeeting$79(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMeetingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEventsConfiguration$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventsConfiguration$76(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEventsConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAttendee$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAttendee$73(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccount$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccount$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVoiceConnectorGroup$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVoiceConnectorGroup$67(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVoiceConnector$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVoiceConnector$64(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUser$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$61(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRoomMembership$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoomMembership$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRoomMembershipResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRoom$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoom$55(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRoomResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createProxySession$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProxySession$52(List metricPublishers, MetricCollector apiCallMetricCollector, CreateProxySessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPhoneNumberOrder$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPhoneNumberOrder$49(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePhoneNumberOrderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMeetingWithAttendees$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMeetingWithAttendees$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMeetingWithAttendeesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMeeting$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMeeting$43(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMeetingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBot$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBot$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAttendee$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAttendee$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccount$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccount$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchUpdateUser$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateUser$31(List metricPublishers, MetricCollector apiCallMetricCollector, BatchUpdateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchUpdatePhoneNumber$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdatePhoneNumber$28(List metricPublishers, MetricCollector apiCallMetricCollector, BatchUpdatePhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchUnsuspendUser$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUnsuspendUser$25(List metricPublishers, MetricCollector apiCallMetricCollector, BatchUnsuspendUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchSuspendUser$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchSuspendUser$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchSuspendUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeletePhoneNumber$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeletePhoneNumber$19(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeletePhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCreateRoomMembership$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateRoomMembership$16(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCreateRoomMembershipResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCreateAttendee$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreateAttendee$13(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCreateAttendeeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateSigninDelegateGroupsWithAccount$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSigninDelegateGroupsWithAccount$10(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateSigninDelegateGroupsWithAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associatePhoneNumbersWithVoiceConnectorGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePhoneNumbersWithVoiceConnectorGroup$7(List metricPublishers, MetricCollector apiCallMetricCollector, AssociatePhoneNumbersWithVoiceConnectorGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associatePhoneNumbersWithVoiceConnector$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePhoneNumbersWithVoiceConnector$4(List metricPublishers, MetricCollector apiCallMetricCollector, AssociatePhoneNumbersWithVoiceConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associatePhoneNumberWithUser$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePhoneNumberWithUser$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociatePhoneNumberWithUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

