/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.PhoneNumberError;
import software.amazon.awssdk.services.chime.model.PhoneNumberErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePhoneNumbersWithVoiceConnectorGroupResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupResponse> {
    private static final SdkField<List<PhoneNumberError>> PHONE_NUMBER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssociatePhoneNumbersWithVoiceConnectorGroupResponse.getter(AssociatePhoneNumbersWithVoiceConnectorGroupResponse::phoneNumberErrors)).setter(AssociatePhoneNumbersWithVoiceConnectorGroupResponse.setter(Builder::phoneNumberErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ERRORS_FIELD));
    private final List<PhoneNumberError> phoneNumberErrors;

    private AssociatePhoneNumbersWithVoiceConnectorGroupResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberErrors = builder.phoneNumberErrors;
    }

    public List<PhoneNumberError> phoneNumberErrors() {
        return this.phoneNumberErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePhoneNumbersWithVoiceConnectorGroupResponse)) {
            return false;
        }
        AssociatePhoneNumbersWithVoiceConnectorGroupResponse other = (AssociatePhoneNumbersWithVoiceConnectorGroupResponse)((Object)obj);
        return Objects.equals(this.phoneNumberErrors(), other.phoneNumberErrors());
    }

    public String toString() {
        return ToString.builder((String)"AssociatePhoneNumbersWithVoiceConnectorGroupResponse").add("PhoneNumberErrors", this.phoneNumberErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberErrors": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberErrors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePhoneNumbersWithVoiceConnectorGroupResponse, T> g) {
        return obj -> g.apply((AssociatePhoneNumbersWithVoiceConnectorGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumberError> phoneNumberErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePhoneNumbersWithVoiceConnectorGroupResponse model) {
            super(model);
            this.phoneNumberErrors(model.phoneNumberErrors);
        }

        public final Collection<PhoneNumberError.Builder> getPhoneNumberErrors() {
            return this.phoneNumberErrors != null ? (Collection)this.phoneNumberErrors.stream().map(PhoneNumberError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copy(phoneNumberErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(PhoneNumberError ... phoneNumberErrors) {
            this.phoneNumberErrors(Arrays.asList(phoneNumberErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder> ... phoneNumberErrors) {
            this.phoneNumberErrors(Stream.of(phoneNumberErrors).map(c -> (PhoneNumberError)((PhoneNumberError.Builder)PhoneNumberError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberErrors(Collection<PhoneNumberError.BuilderImpl> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copyFromBuilder(phoneNumberErrors);
        }

        @Override
        public AssociatePhoneNumbersWithVoiceConnectorGroupResponse build() {
            return new AssociatePhoneNumbersWithVoiceConnectorGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupResponse> {
        public Builder phoneNumberErrors(Collection<PhoneNumberError> var1);

        public Builder phoneNumberErrors(PhoneNumberError ... var1);

        public Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder> ... var1);
    }
}

