/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotRequest;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChimeWebhookConfigurationRequest
extends ChatbotRequest
implements ToCopyableBuilder<Builder, UpdateChimeWebhookConfigurationRequest> {
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChatConfigurationArn").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::chatConfigurationArn)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::chatConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build()}).build();
    private static final SdkField<String> WEBHOOK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebhookDescription").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::webhookDescription)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::webhookDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookDescription").build()}).build();
    private static final SdkField<String> WEBHOOK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebhookUrl").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::webhookUrl)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::webhookUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookUrl").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::snsTopicArns)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::iamRoleArn)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(UpdateChimeWebhookConfigurationRequest.getter(UpdateChimeWebhookConfigurationRequest::loggingLevel)).setter(UpdateChimeWebhookConfigurationRequest.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONFIGURATION_ARN_FIELD, WEBHOOK_DESCRIPTION_FIELD, WEBHOOK_URL_FIELD, SNS_TOPIC_ARNS_FIELD, IAM_ROLE_ARN_FIELD, LOGGING_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateChimeWebhookConfigurationRequest.memberNameToFieldInitializer();
    private final String chatConfigurationArn;
    private final String webhookDescription;
    private final String webhookUrl;
    private final List<String> snsTopicArns;
    private final String iamRoleArn;
    private final String loggingLevel;

    private UpdateChimeWebhookConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.webhookDescription = builder.webhookDescription;
        this.webhookUrl = builder.webhookUrl;
        this.snsTopicArns = builder.snsTopicArns;
        this.iamRoleArn = builder.iamRoleArn;
        this.loggingLevel = builder.loggingLevel;
    }

    public final String chatConfigurationArn() {
        return this.chatConfigurationArn;
    }

    public final String webhookDescription() {
        return this.webhookDescription;
    }

    public final String webhookUrl() {
        return this.webhookUrl;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChimeWebhookConfigurationRequest)) {
            return false;
        }
        UpdateChimeWebhookConfigurationRequest other = (UpdateChimeWebhookConfigurationRequest)((Object)obj);
        return Objects.equals(this.chatConfigurationArn(), other.chatConfigurationArn()) && Objects.equals(this.webhookDescription(), other.webhookDescription()) && Objects.equals(this.webhookUrl(), other.webhookUrl()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.loggingLevel(), other.loggingLevel());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChimeWebhookConfigurationRequest").add("ChatConfigurationArn", (Object)this.chatConfigurationArn()).add("WebhookDescription", (Object)(this.webhookDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("WebhookUrl", (Object)(this.webhookUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("IamRoleArn", (Object)this.iamRoleArn()).add("LoggingLevel", (Object)this.loggingLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChatConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.chatConfigurationArn()));
            }
            case "WebhookDescription": {
                return Optional.ofNullable(clazz.cast(this.webhookDescription()));
            }
            case "WebhookUrl": {
                return Optional.ofNullable(clazz.cast(this.webhookUrl()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChatConfigurationArn", CHAT_CONFIGURATION_ARN_FIELD);
        map.put("WebhookDescription", WEBHOOK_DESCRIPTION_FIELD);
        map.put("WebhookUrl", WEBHOOK_URL_FIELD);
        map.put("SnsTopicArns", SNS_TOPIC_ARNS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("LoggingLevel", LOGGING_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChimeWebhookConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateChimeWebhookConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotRequest.BuilderImpl
    implements Builder {
        private String chatConfigurationArn;
        private String webhookDescription;
        private String webhookUrl;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;
        private String loggingLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChimeWebhookConfigurationRequest model) {
            super(model);
            this.chatConfigurationArn(model.chatConfigurationArn);
            this.webhookDescription(model.webhookDescription);
            this.webhookUrl(model.webhookUrl);
            this.snsTopicArns(model.snsTopicArns);
            this.iamRoleArn(model.iamRoleArn);
            this.loggingLevel(model.loggingLevel);
        }

        public final String getChatConfigurationArn() {
            return this.chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getWebhookDescription() {
            return this.webhookDescription;
        }

        public final void setWebhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
        }

        @Override
        public final Builder webhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
            return this;
        }

        public final String getWebhookUrl() {
            return this.webhookUrl;
        }

        public final void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        @Override
        public final Builder webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChimeWebhookConfigurationRequest build() {
            return new UpdateChimeWebhookConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChatbotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChimeWebhookConfigurationRequest> {
        public Builder chatConfigurationArn(String var1);

        public Builder webhookDescription(String var1);

        public Builder webhookUrl(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder iamRoleArn(String var1);

        public Builder loggingLevel(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

