/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * The <i>AWS Chatbot API Reference</i> provides descriptions, API request parameters, and the XML response for each of
 * the AWS Chatbot API actions.
 * </p>
 * <p>
 * AWS Chatbot APIs are currently available in the following Regions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * US East (Ohio) - <code>us-east-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * US West (Oregon) - <code>us-west-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Asia Pacific (Singapore) - <code>ap-southeast-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Europe (Ireland) - <code>eu-west-1</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * The AWS Chatbot console can only be used in US East (Ohio). Your configuration data however, is stored in each of the
 * relevant available Regions.
 * </p>
 * <note>
 * <p>
 * Your AWS CloudTrail events are logged in whatever Region you call from, not US East (N. Virginia) by default.
 * </p>
 * </note>
 */
package software.amazon.awssdk.services.chatbot;