/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSlackUserIdentitiesResponse extends ChatbotResponse implements
        ToCopyableBuilder<DescribeSlackUserIdentitiesResponse.Builder, DescribeSlackUserIdentitiesResponse> {
    private static final SdkField<List<SlackUserIdentity>> SLACK_USER_IDENTITIES_FIELD = SdkField
            .<List<SlackUserIdentity>> builder(MarshallingType.LIST)
            .memberName("SlackUserIdentities")
            .getter(getter(DescribeSlackUserIdentitiesResponse::slackUserIdentities))
            .setter(setter(Builder::slackUserIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackUserIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlackUserIdentity> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlackUserIdentity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSlackUserIdentitiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_USER_IDENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SlackUserIdentity> slackUserIdentities;

    private final String nextToken;

    private DescribeSlackUserIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.slackUserIdentities = builder.slackUserIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlackUserIdentities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlackUserIdentities() {
        return slackUserIdentities != null && !(slackUserIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Slack User Identities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlackUserIdentities} method.
     * </p>
     * 
     * @return A list of Slack User Identities.
     */
    public final List<SlackUserIdentity> slackUserIdentities() {
        return slackUserIdentities;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSlackUserIdentities() ? slackUserIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlackUserIdentitiesResponse)) {
            return false;
        }
        DescribeSlackUserIdentitiesResponse other = (DescribeSlackUserIdentitiesResponse) obj;
        return hasSlackUserIdentities() == other.hasSlackUserIdentities()
                && Objects.equals(slackUserIdentities(), other.slackUserIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSlackUserIdentitiesResponse")
                .add("SlackUserIdentities", hasSlackUserIdentities() ? slackUserIdentities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlackUserIdentities":
            return Optional.ofNullable(clazz.cast(slackUserIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SlackUserIdentities", SLACK_USER_IDENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlackUserIdentitiesResponse, T> g) {
        return obj -> g.apply((DescribeSlackUserIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSlackUserIdentitiesResponse> {
        /**
         * <p>
         * A list of Slack User Identities.
         * </p>
         * 
         * @param slackUserIdentities
         *        A list of Slack User Identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackUserIdentities(Collection<SlackUserIdentity> slackUserIdentities);

        /**
         * <p>
         * A list of Slack User Identities.
         * </p>
         * 
         * @param slackUserIdentities
         *        A list of Slack User Identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackUserIdentities(SlackUserIdentity... slackUserIdentities);

        /**
         * <p>
         * A list of Slack User Identities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.SlackUserIdentity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chatbot.model.SlackUserIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.SlackUserIdentity.Builder#build()} is called immediately
         * and its result is passed to {@link #slackUserIdentities(List<SlackUserIdentity>)}.
         * 
         * @param slackUserIdentities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.SlackUserIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slackUserIdentities(java.util.Collection<SlackUserIdentity>)
         */
        Builder slackUserIdentities(Consumer<SlackUserIdentity.Builder>... slackUserIdentities);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private List<SlackUserIdentity> slackUserIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlackUserIdentitiesResponse model) {
            super(model);
            slackUserIdentities(model.slackUserIdentities);
            nextToken(model.nextToken);
        }

        public final List<SlackUserIdentity.Builder> getSlackUserIdentities() {
            List<SlackUserIdentity.Builder> result = SlackUserIdentitiesListCopier.copyToBuilder(this.slackUserIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackUserIdentities(Collection<SlackUserIdentity.BuilderImpl> slackUserIdentities) {
            this.slackUserIdentities = SlackUserIdentitiesListCopier.copyFromBuilder(slackUserIdentities);
        }

        @Override
        public final Builder slackUserIdentities(Collection<SlackUserIdentity> slackUserIdentities) {
            this.slackUserIdentities = SlackUserIdentitiesListCopier.copy(slackUserIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackUserIdentities(SlackUserIdentity... slackUserIdentities) {
            slackUserIdentities(Arrays.asList(slackUserIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackUserIdentities(Consumer<SlackUserIdentity.Builder>... slackUserIdentities) {
            slackUserIdentities(Stream.of(slackUserIdentities).map(c -> SlackUserIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSlackUserIdentitiesResponse build() {
            return new DescribeSlackUserIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
