/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentCriteriaOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomActionAttachmentCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomActionAttachmentCriteria> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(CustomActionAttachmentCriteria.getter(CustomActionAttachmentCriteria::operatorAsString)).setter(CustomActionAttachmentCriteria.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<String> VARIABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariableName").getter(CustomActionAttachmentCriteria.getter(CustomActionAttachmentCriteria::variableName)).setter(CustomActionAttachmentCriteria.setter(Builder::variableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariableName").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(CustomActionAttachmentCriteria.getter(CustomActionAttachmentCriteria::value)).setter(CustomActionAttachmentCriteria.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VARIABLE_NAME_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomActionAttachmentCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operator;
    private final String variableName;
    private final String value;

    private CustomActionAttachmentCriteria(BuilderImpl builder) {
        this.operator = builder.operator;
        this.variableName = builder.variableName;
        this.value = builder.value;
    }

    public final CustomActionAttachmentCriteriaOperator operator() {
        return CustomActionAttachmentCriteriaOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final String variableName() {
        return this.variableName;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionAttachmentCriteria)) {
            return false;
        }
        CustomActionAttachmentCriteria other = (CustomActionAttachmentCriteria)obj;
        return Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.variableName(), other.variableName()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"CustomActionAttachmentCriteria").add("Operator", (Object)this.operatorAsString()).add("VariableName", (Object)this.variableName()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "VariableName": {
                return Optional.ofNullable(clazz.cast(this.variableName()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("VariableName", VARIABLE_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionAttachmentCriteria, T> g) {
        return obj -> g.apply((CustomActionAttachmentCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operator;
        private String variableName;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionAttachmentCriteria model) {
            this.operator(model.operator);
            this.variableName(model.variableName);
            this.value(model.value);
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(CustomActionAttachmentCriteriaOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getVariableName() {
            return this.variableName;
        }

        public final void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        @Override
        public final Builder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public CustomActionAttachmentCriteria build() {
            return new CustomActionAttachmentCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomActionAttachmentCriteria> {
        public Builder operator(String var1);

        public Builder operator(CustomActionAttachmentCriteriaOperator var1);

        public Builder variableName(String var1);

        public Builder value(String var1);
    }
}

