/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotRequest;
import software.amazon.awssdk.services.chatbot.model.CustomActionAttachment;
import software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentListCopier;
import software.amazon.awssdk.services.chatbot.model.CustomActionDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomActionRequest
extends ChatbotRequest
implements ToCopyableBuilder<Builder, UpdateCustomActionRequest> {
    private static final SdkField<String> CUSTOM_ACTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomActionArn").getter(UpdateCustomActionRequest.getter(UpdateCustomActionRequest::customActionArn)).setter(UpdateCustomActionRequest.setter(Builder::customActionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionArn").build()}).build();
    private static final SdkField<CustomActionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateCustomActionRequest.getter(UpdateCustomActionRequest::definition)).setter(UpdateCustomActionRequest.setter(Builder::definition)).constructor(CustomActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(UpdateCustomActionRequest.getter(UpdateCustomActionRequest::aliasName)).setter(UpdateCustomActionRequest.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<List<CustomActionAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(UpdateCustomActionRequest.getter(UpdateCustomActionRequest::attachments)).setter(UpdateCustomActionRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomActionAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_ARN_FIELD, DEFINITION_FIELD, ALIAS_NAME_FIELD, ATTACHMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCustomActionRequest.memberNameToFieldInitializer();
    private final String customActionArn;
    private final CustomActionDefinition definition;
    private final String aliasName;
    private final List<CustomActionAttachment> attachments;

    private UpdateCustomActionRequest(BuilderImpl builder) {
        super(builder);
        this.customActionArn = builder.customActionArn;
        this.definition = builder.definition;
        this.aliasName = builder.aliasName;
        this.attachments = builder.attachments;
    }

    public final String customActionArn() {
        return this.customActionArn;
    }

    public final CustomActionDefinition definition() {
        return this.definition;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<CustomActionAttachment> attachments() {
        return this.attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customActionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomActionRequest)) {
            return false;
        }
        UpdateCustomActionRequest other = (UpdateCustomActionRequest)((Object)obj);
        return Objects.equals(this.customActionArn(), other.customActionArn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.aliasName(), other.aliasName()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomActionRequest").add("CustomActionArn", (Object)this.customActionArn()).add("Definition", (Object)this.definition()).add("AliasName", (Object)this.aliasName()).add("Attachments", this.hasAttachments() ? this.attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomActionArn": {
                return Optional.ofNullable(clazz.cast(this.customActionArn()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomActionArn", CUSTOM_ACTION_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomActionRequest, T> g) {
        return obj -> g.apply((UpdateCustomActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotRequest.BuilderImpl
    implements Builder {
        private String customActionArn;
        private CustomActionDefinition definition;
        private String aliasName;
        private List<CustomActionAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomActionRequest model) {
            super(model);
            this.customActionArn(model.customActionArn);
            this.definition(model.definition);
            this.aliasName(model.aliasName);
            this.attachments(model.attachments);
        }

        public final String getCustomActionArn() {
            return this.customActionArn;
        }

        public final void setCustomActionArn(String customActionArn) {
            this.customActionArn = customActionArn;
        }

        @Override
        public final Builder customActionArn(String customActionArn) {
            this.customActionArn = customActionArn;
            return this;
        }

        public final CustomActionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(CustomActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(CustomActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final List<CustomActionAttachment.Builder> getAttachments() {
            List<CustomActionAttachment.Builder> result = CustomActionAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<CustomActionAttachment.BuilderImpl> attachments) {
            this.attachments = CustomActionAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<CustomActionAttachment> attachments) {
            this.attachments = CustomActionAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(CustomActionAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<CustomActionAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (CustomActionAttachment)((CustomActionAttachment.Builder)CustomActionAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomActionRequest build() {
            return new UpdateCustomActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChatbotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomActionRequest> {
        public Builder customActionArn(String var1);

        public Builder definition(CustomActionDefinition var1);

        default public Builder definition(Consumer<CustomActionDefinition.Builder> definition) {
            return this.definition((CustomActionDefinition)((CustomActionDefinition.Builder)CustomActionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder aliasName(String var1);

        public Builder attachments(Collection<CustomActionAttachment> var1);

        public Builder attachments(CustomActionAttachment ... var1);

        public Builder attachments(Consumer<CustomActionAttachment.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

