/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.GuardrailPolicyArnListCopier;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.services.chatbot.model.Tag;
import software.amazon.awssdk.services.chatbot.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TeamsChannelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TeamsChannelConfiguration> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::channelId)).setter(TeamsChannelConfiguration.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::channelName)).setter(TeamsChannelConfiguration.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamId").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::teamId)).setter(TeamsChannelConfiguration.setter(Builder::teamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()}).build();
    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamName").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::teamName)).setter(TeamsChannelConfiguration.setter(Builder::teamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::tenantId)).setter(TeamsChannelConfiguration.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChatConfigurationArn").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::chatConfigurationArn)).setter(TeamsChannelConfiguration.setter(Builder::chatConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::iamRoleArn)).setter(TeamsChannelConfiguration.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::snsTopicArns)).setter(TeamsChannelConfiguration.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::configurationName)).setter(TeamsChannelConfiguration.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::loggingLevel)).setter(TeamsChannelConfiguration.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final SdkField<List<String>> GUARDRAIL_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GuardrailPolicyArns").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::guardrailPolicyArns)).setter(TeamsChannelConfiguration.setter(Builder::guardrailPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardrailPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::userAuthorizationRequired)).setter(TeamsChannelConfiguration.setter(Builder::userAuthorizationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::tags)).setter(TeamsChannelConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::state)).setter(TeamsChannelConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(TeamsChannelConfiguration.getter(TeamsChannelConfiguration::stateReason)).setter(TeamsChannelConfiguration.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, TEAM_ID_FIELD, TEAM_NAME_FIELD, TENANT_ID_FIELD, CHAT_CONFIGURATION_ARN_FIELD, IAM_ROLE_ARN_FIELD, SNS_TOPIC_ARNS_FIELD, CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD, GUARDRAIL_POLICY_ARNS_FIELD, USER_AUTHORIZATION_REQUIRED_FIELD, TAGS_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TeamsChannelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelId;
    private final String channelName;
    private final String teamId;
    private final String teamName;
    private final String tenantId;
    private final String chatConfigurationArn;
    private final String iamRoleArn;
    private final List<String> snsTopicArns;
    private final String configurationName;
    private final String loggingLevel;
    private final List<String> guardrailPolicyArns;
    private final Boolean userAuthorizationRequired;
    private final List<Tag> tags;
    private final String state;
    private final String stateReason;

    private TeamsChannelConfiguration(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
        this.tenantId = builder.tenantId;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.snsTopicArns = builder.snsTopicArns;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
        this.guardrailPolicyArns = builder.guardrailPolicyArns;
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
        this.tags = builder.tags;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String teamId() {
        return this.teamId;
    }

    public final String teamName() {
        return this.teamName;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String chatConfigurationArn() {
        return this.chatConfigurationArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    public final boolean hasGuardrailPolicyArns() {
        return this.guardrailPolicyArns != null && !(this.guardrailPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> guardrailPolicyArns() {
        return this.guardrailPolicyArns;
    }

    public final Boolean userAuthorizationRequired() {
        return this.userAuthorizationRequired;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String state() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAuthorizationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamsChannelConfiguration)) {
            return false;
        }
        TeamsChannelConfiguration other = (TeamsChannelConfiguration)obj;
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.teamId(), other.teamId()) && Objects.equals(this.teamName(), other.teamName()) && Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.chatConfigurationArn(), other.chatConfigurationArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && this.hasGuardrailPolicyArns() == other.hasGuardrailPolicyArns() && Objects.equals(this.guardrailPolicyArns(), other.guardrailPolicyArns()) && Objects.equals(this.userAuthorizationRequired(), other.userAuthorizationRequired()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"TeamsChannelConfiguration").add("ChannelId", (Object)this.channelId()).add("ChannelName", (Object)(this.channelName() == null ? null : "*** Sensitive Data Redacted ***")).add("TeamId", (Object)this.teamId()).add("TeamName", (Object)(this.teamName() == null ? null : "*** Sensitive Data Redacted ***")).add("TenantId", (Object)this.tenantId()).add("ChatConfigurationArn", (Object)this.chatConfigurationArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("ConfigurationName", (Object)this.configurationName()).add("LoggingLevel", (Object)this.loggingLevel()).add("GuardrailPolicyArns", this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null).add("UserAuthorizationRequired", (Object)this.userAuthorizationRequired()).add("Tags", this.hasTags() ? this.tags() : null).add("State", (Object)this.state()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "TeamId": {
                return Optional.ofNullable(clazz.cast(this.teamId()));
            }
            case "TeamName": {
                return Optional.ofNullable(clazz.cast(this.teamName()));
            }
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "ChatConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.chatConfigurationArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "GuardrailPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.guardrailPolicyArns()));
            }
            case "UserAuthorizationRequired": {
                return Optional.ofNullable(clazz.cast(this.userAuthorizationRequired()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("TeamId", TEAM_ID_FIELD);
        map.put("TeamName", TEAM_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("ChatConfigurationArn", CHAT_CONFIGURATION_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("SnsTopicArns", SNS_TOPIC_ARNS_FIELD);
        map.put("ConfigurationName", CONFIGURATION_NAME_FIELD);
        map.put("LoggingLevel", LOGGING_LEVEL_FIELD);
        map.put("GuardrailPolicyArns", GUARDRAIL_POLICY_ARNS_FIELD);
        map.put("UserAuthorizationRequired", USER_AUTHORIZATION_REQUIRED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TeamsChannelConfiguration, T> g) {
        return obj -> g.apply((TeamsChannelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelId;
        private String channelName;
        private String teamId;
        private String teamName;
        private String tenantId;
        private String chatConfigurationArn;
        private String iamRoleArn;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String configurationName;
        private String loggingLevel;
        private List<String> guardrailPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean userAuthorizationRequired;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TeamsChannelConfiguration model) {
            this.channelId(model.channelId);
            this.channelName(model.channelName);
            this.teamId(model.teamId);
            this.teamName(model.teamName);
            this.tenantId(model.tenantId);
            this.chatConfigurationArn(model.chatConfigurationArn);
            this.iamRoleArn(model.iamRoleArn);
            this.snsTopicArns(model.snsTopicArns);
            this.configurationName(model.configurationName);
            this.loggingLevel(model.loggingLevel);
            this.guardrailPolicyArns(model.guardrailPolicyArns);
            this.userAuthorizationRequired(model.userAuthorizationRequired);
            this.tags(model.tags);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getTeamId() {
            return this.teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return this.teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getChatConfigurationArn() {
            return this.chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Collection<String> getGuardrailPolicyArns() {
            if (this.guardrailPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.guardrailPolicyArns;
        }

        public final void setGuardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
        }

        @Override
        public final Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailPolicyArns(String ... guardrailPolicyArns) {
            this.guardrailPolicyArns(Arrays.asList(guardrailPolicyArns));
            return this;
        }

        public final Boolean getUserAuthorizationRequired() {
            return this.userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public TeamsChannelConfiguration build() {
            return new TeamsChannelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TeamsChannelConfiguration> {
        public Builder channelId(String var1);

        public Builder channelName(String var1);

        public Builder teamId(String var1);

        public Builder teamName(String var1);

        public Builder tenantId(String var1);

        public Builder chatConfigurationArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder configurationName(String var1);

        public Builder loggingLevel(String var1);

        public Builder guardrailPolicyArns(Collection<String> var1);

        public Builder guardrailPolicyArns(String ... var1);

        public Builder userAuthorizationRequired(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder state(String var1);

        public Builder stateReason(String var1);
    }
}

