/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsRequest;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsResponse;

public class ListCustomActionsIterable
implements SdkIterable<ListCustomActionsResponse> {
    private final ChatbotClient client;
    private final ListCustomActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomActionsIterable(ChatbotClient client, ListCustomActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomActionsResponseFetcher();
    }

    public Iterator<ListCustomActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> customActions() {
        Function<ListCustomActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customActions() != null) {
                return response.customActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomActionsResponseFetcher
    implements SyncPageFetcher<ListCustomActionsResponse> {
        private ListCustomActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomActionsResponse nextPage(ListCustomActionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomActionsIterable.this.client.listCustomActions(ListCustomActionsIterable.this.firstRequest);
            }
            return ListCustomActionsIterable.this.client.listCustomActions((ListCustomActionsRequest)((Object)ListCustomActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

