/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.AssociationListing;
import software.amazon.awssdk.services.chatbot.model.ListAssociationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListAssociationsResponse;

public class ListAssociationsIterable
implements SdkIterable<ListAssociationsResponse> {
    private final ChatbotClient client;
    private final ListAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociationsIterable(ChatbotClient client, ListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public Iterator<ListAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociationListing> associations() {
        Function<ListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociationsResponseFetcher
    implements SyncPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociationsResponse nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsIterable.this.client.listAssociations(ListAssociationsIterable.this.firstRequest);
            }
            return ListAssociationsIterable.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

