/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotResponse;
import software.amazon.awssdk.services.chatbot.model.ConfiguredTeam;
import software.amazon.awssdk.services.chatbot.model.ConfiguredTeamsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMicrosoftTeamsConfiguredTeamsResponse
extends ChatbotResponse
implements ToCopyableBuilder<Builder, ListMicrosoftTeamsConfiguredTeamsResponse> {
    private static final SdkField<List<ConfiguredTeam>> CONFIGURED_TEAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfiguredTeams").getter(ListMicrosoftTeamsConfiguredTeamsResponse.getter(ListMicrosoftTeamsConfiguredTeamsResponse::configuredTeams)).setter(ListMicrosoftTeamsConfiguredTeamsResponse.setter(Builder::configuredTeams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredTeams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfiguredTeam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMicrosoftTeamsConfiguredTeamsResponse.getter(ListMicrosoftTeamsConfiguredTeamsResponse::nextToken)).setter(ListMicrosoftTeamsConfiguredTeamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TEAMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfiguredTeams", CONFIGURED_TEAMS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfiguredTeam> configuredTeams;
    private final String nextToken;

    private ListMicrosoftTeamsConfiguredTeamsResponse(BuilderImpl builder) {
        super(builder);
        this.configuredTeams = builder.configuredTeams;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfiguredTeams() {
        return this.configuredTeams != null && !(this.configuredTeams instanceof SdkAutoConstructList);
    }

    public final List<ConfiguredTeam> configuredTeams() {
        return this.configuredTeams;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredTeams() ? this.configuredTeams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMicrosoftTeamsConfiguredTeamsResponse)) {
            return false;
        }
        ListMicrosoftTeamsConfiguredTeamsResponse other = (ListMicrosoftTeamsConfiguredTeamsResponse)((Object)obj);
        return this.hasConfiguredTeams() == other.hasConfiguredTeams() && Objects.equals(this.configuredTeams(), other.configuredTeams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMicrosoftTeamsConfiguredTeamsResponse").add("ConfiguredTeams", this.hasConfiguredTeams() ? this.configuredTeams() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfiguredTeams": {
                return Optional.ofNullable(clazz.cast(this.configuredTeams()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMicrosoftTeamsConfiguredTeamsResponse, T> g) {
        return obj -> g.apply((ListMicrosoftTeamsConfiguredTeamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotResponse.BuilderImpl
    implements Builder {
        private List<ConfiguredTeam> configuredTeams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMicrosoftTeamsConfiguredTeamsResponse model) {
            super(model);
            this.configuredTeams(model.configuredTeams);
            this.nextToken(model.nextToken);
        }

        public final List<ConfiguredTeam.Builder> getConfiguredTeams() {
            List<ConfiguredTeam.Builder> result = ConfiguredTeamsListCopier.copyToBuilder(this.configuredTeams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredTeams(Collection<ConfiguredTeam.BuilderImpl> configuredTeams) {
            this.configuredTeams = ConfiguredTeamsListCopier.copyFromBuilder(configuredTeams);
        }

        @Override
        public final Builder configuredTeams(Collection<ConfiguredTeam> configuredTeams) {
            this.configuredTeams = ConfiguredTeamsListCopier.copy(configuredTeams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredTeams(ConfiguredTeam ... configuredTeams) {
            this.configuredTeams(Arrays.asList(configuredTeams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredTeams(Consumer<ConfiguredTeam.Builder> ... configuredTeams) {
            this.configuredTeams(Stream.of(configuredTeams).map(c -> (ConfiguredTeam)((ConfiguredTeam.Builder)ConfiguredTeam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMicrosoftTeamsConfiguredTeamsResponse build() {
            return new ListMicrosoftTeamsConfiguredTeamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChatbotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMicrosoftTeamsConfiguredTeamsResponse> {
        public Builder configuredTeams(Collection<ConfiguredTeam> var1);

        public Builder configuredTeams(ConfiguredTeam ... var1);

        public Builder configuredTeams(Consumer<ConfiguredTeam.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

