/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotRequest;
import software.amazon.awssdk.services.chatbot.model.GuardrailPolicyArnListCopier;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMicrosoftTeamsChannelConfigurationRequest
extends ChatbotRequest
implements ToCopyableBuilder<Builder, UpdateMicrosoftTeamsChannelConfigurationRequest> {
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChatConfigurationArn").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::chatConfigurationArn)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::chatConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::channelId)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::channelName)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::snsTopicArns)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::iamRoleArn)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::loggingLevel)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final SdkField<List<String>> GUARDRAIL_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GuardrailPolicyArns").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::guardrailPolicyArns)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::guardrailPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardrailPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired").getter(UpdateMicrosoftTeamsChannelConfigurationRequest.getter(UpdateMicrosoftTeamsChannelConfigurationRequest::userAuthorizationRequired)).setter(UpdateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::userAuthorizationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONFIGURATION_ARN_FIELD, CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, SNS_TOPIC_ARNS_FIELD, IAM_ROLE_ARN_FIELD, LOGGING_LEVEL_FIELD, GUARDRAIL_POLICY_ARNS_FIELD, USER_AUTHORIZATION_REQUIRED_FIELD));
    private final String chatConfigurationArn;
    private final String channelId;
    private final String channelName;
    private final List<String> snsTopicArns;
    private final String iamRoleArn;
    private final String loggingLevel;
    private final List<String> guardrailPolicyArns;
    private final Boolean userAuthorizationRequired;

    private UpdateMicrosoftTeamsChannelConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.snsTopicArns = builder.snsTopicArns;
        this.iamRoleArn = builder.iamRoleArn;
        this.loggingLevel = builder.loggingLevel;
        this.guardrailPolicyArns = builder.guardrailPolicyArns;
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
    }

    public final String chatConfigurationArn() {
        return this.chatConfigurationArn;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    public final boolean hasGuardrailPolicyArns() {
        return this.guardrailPolicyArns != null && !(this.guardrailPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> guardrailPolicyArns() {
        return this.guardrailPolicyArns;
    }

    public final Boolean userAuthorizationRequired() {
        return this.userAuthorizationRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAuthorizationRequired());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMicrosoftTeamsChannelConfigurationRequest)) {
            return false;
        }
        UpdateMicrosoftTeamsChannelConfigurationRequest other = (UpdateMicrosoftTeamsChannelConfigurationRequest)((Object)obj);
        return Objects.equals(this.chatConfigurationArn(), other.chatConfigurationArn()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.channelName(), other.channelName()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && this.hasGuardrailPolicyArns() == other.hasGuardrailPolicyArns() && Objects.equals(this.guardrailPolicyArns(), other.guardrailPolicyArns()) && Objects.equals(this.userAuthorizationRequired(), other.userAuthorizationRequired());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMicrosoftTeamsChannelConfigurationRequest").add("ChatConfigurationArn", (Object)this.chatConfigurationArn()).add("ChannelId", (Object)this.channelId()).add("ChannelName", (Object)(this.channelName() == null ? null : "*** Sensitive Data Redacted ***")).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("IamRoleArn", (Object)this.iamRoleArn()).add("LoggingLevel", (Object)this.loggingLevel()).add("GuardrailPolicyArns", this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null).add("UserAuthorizationRequired", (Object)this.userAuthorizationRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChatConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.chatConfigurationArn()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "GuardrailPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.guardrailPolicyArns()));
            }
            case "UserAuthorizationRequired": {
                return Optional.ofNullable(clazz.cast(this.userAuthorizationRequired()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMicrosoftTeamsChannelConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateMicrosoftTeamsChannelConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotRequest.BuilderImpl
    implements Builder {
        private String chatConfigurationArn;
        private String channelId;
        private String channelName;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;
        private String loggingLevel;
        private List<String> guardrailPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean userAuthorizationRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMicrosoftTeamsChannelConfigurationRequest model) {
            super(model);
            this.chatConfigurationArn(model.chatConfigurationArn);
            this.channelId(model.channelId);
            this.channelName(model.channelName);
            this.snsTopicArns(model.snsTopicArns);
            this.iamRoleArn(model.iamRoleArn);
            this.loggingLevel(model.loggingLevel);
            this.guardrailPolicyArns(model.guardrailPolicyArns);
            this.userAuthorizationRequired(model.userAuthorizationRequired);
        }

        public final String getChatConfigurationArn() {
            return this.chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Collection<String> getGuardrailPolicyArns() {
            if (this.guardrailPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.guardrailPolicyArns;
        }

        public final void setGuardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
        }

        @Override
        public final Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailPolicyArns(String ... guardrailPolicyArns) {
            this.guardrailPolicyArns(Arrays.asList(guardrailPolicyArns));
            return this;
        }

        public final Boolean getUserAuthorizationRequired() {
            return this.userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMicrosoftTeamsChannelConfigurationRequest build() {
            return new UpdateMicrosoftTeamsChannelConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChatbotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMicrosoftTeamsChannelConfigurationRequest> {
        public Builder chatConfigurationArn(String var1);

        public Builder channelId(String var1);

        public Builder channelName(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder iamRoleArn(String var1);

        public Builder loggingLevel(String var1);

        public Builder guardrailPolicyArns(Collection<String> var1);

        public Builder guardrailPolicyArns(String ... var1);

        public Builder userAuthorizationRequired(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

