/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse;

public class ListMicrosoftTeamsChannelConfigurationsPublisher
implements SdkPublisher<ListMicrosoftTeamsChannelConfigurationsResponse> {
    private final ChatbotAsyncClient client;
    private final ListMicrosoftTeamsChannelConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMicrosoftTeamsChannelConfigurationsPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsChannelConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMicrosoftTeamsChannelConfigurationsPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsChannelConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMicrosoftTeamsChannelConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMicrosoftTeamsChannelConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMicrosoftTeamsChannelConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListMicrosoftTeamsChannelConfigurationsResponse> {
        private ListMicrosoftTeamsChannelConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListMicrosoftTeamsChannelConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMicrosoftTeamsChannelConfigurationsResponse> nextPage(ListMicrosoftTeamsChannelConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListMicrosoftTeamsChannelConfigurationsPublisher.this.client.listMicrosoftTeamsChannelConfigurations(ListMicrosoftTeamsChannelConfigurationsPublisher.this.firstRequest);
            }
            return ListMicrosoftTeamsChannelConfigurationsPublisher.this.client.listMicrosoftTeamsChannelConfigurations((ListMicrosoftTeamsChannelConfigurationsRequest)((Object)ListMicrosoftTeamsChannelConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

