/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;

public class DescribeSlackWorkspacesPublisher
implements SdkPublisher<DescribeSlackWorkspacesResponse> {
    private final ChatbotAsyncClient client;
    private final DescribeSlackWorkspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSlackWorkspacesPublisher(ChatbotAsyncClient client, DescribeSlackWorkspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSlackWorkspacesPublisher(ChatbotAsyncClient client, DescribeSlackWorkspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSlackWorkspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSlackWorkspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeSlackWorkspacesResponseFetcher
    implements AsyncPageFetcher<DescribeSlackWorkspacesResponse> {
        private DescribeSlackWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSlackWorkspacesResponse> nextPage(DescribeSlackWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackWorkspacesPublisher.this.client.describeSlackWorkspaces(DescribeSlackWorkspacesPublisher.this.firstRequest);
            }
            return DescribeSlackWorkspacesPublisher.this.client.describeSlackWorkspaces((DescribeSlackWorkspacesRequest)((Object)DescribeSlackWorkspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

