/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotResponse;
import software.amazon.awssdk.services.chatbot.model.TeamChannelConfigurationsListCopier;
import software.amazon.awssdk.services.chatbot.model.TeamsChannelConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMicrosoftTeamsChannelConfigurationsResponse
extends ChatbotResponse
implements ToCopyableBuilder<Builder, ListMicrosoftTeamsChannelConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMicrosoftTeamsChannelConfigurationsResponse.getter(ListMicrosoftTeamsChannelConfigurationsResponse::nextToken)).setter(ListMicrosoftTeamsChannelConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TeamsChannelConfiguration>> TEAM_CHANNEL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TeamChannelConfigurations").getter(ListMicrosoftTeamsChannelConfigurationsResponse.getter(ListMicrosoftTeamsChannelConfigurationsResponse::teamChannelConfigurations)).setter(ListMicrosoftTeamsChannelConfigurationsResponse.setter(Builder::teamChannelConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamChannelConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TeamsChannelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEAM_CHANNEL_CONFIGURATIONS_FIELD));
    private final String nextToken;
    private final List<TeamsChannelConfiguration> teamChannelConfigurations;

    private ListMicrosoftTeamsChannelConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.teamChannelConfigurations = builder.teamChannelConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTeamChannelConfigurations() {
        return this.teamChannelConfigurations != null && !(this.teamChannelConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TeamsChannelConfiguration> teamChannelConfigurations() {
        return this.teamChannelConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTeamChannelConfigurations() ? this.teamChannelConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMicrosoftTeamsChannelConfigurationsResponse)) {
            return false;
        }
        ListMicrosoftTeamsChannelConfigurationsResponse other = (ListMicrosoftTeamsChannelConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTeamChannelConfigurations() == other.hasTeamChannelConfigurations() && Objects.equals(this.teamChannelConfigurations(), other.teamChannelConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListMicrosoftTeamsChannelConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("TeamChannelConfigurations", this.hasTeamChannelConfigurations() ? this.teamChannelConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TeamChannelConfigurations": {
                return Optional.ofNullable(clazz.cast(this.teamChannelConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMicrosoftTeamsChannelConfigurationsResponse, T> g) {
        return obj -> g.apply((ListMicrosoftTeamsChannelConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TeamsChannelConfiguration> teamChannelConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMicrosoftTeamsChannelConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.teamChannelConfigurations(model.teamChannelConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TeamsChannelConfiguration.Builder> getTeamChannelConfigurations() {
            List<TeamsChannelConfiguration.Builder> result = TeamChannelConfigurationsListCopier.copyToBuilder(this.teamChannelConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTeamChannelConfigurations(Collection<TeamsChannelConfiguration.BuilderImpl> teamChannelConfigurations) {
            this.teamChannelConfigurations = TeamChannelConfigurationsListCopier.copyFromBuilder(teamChannelConfigurations);
        }

        @Override
        public final Builder teamChannelConfigurations(Collection<TeamsChannelConfiguration> teamChannelConfigurations) {
            this.teamChannelConfigurations = TeamChannelConfigurationsListCopier.copy(teamChannelConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamChannelConfigurations(TeamsChannelConfiguration ... teamChannelConfigurations) {
            this.teamChannelConfigurations(Arrays.asList(teamChannelConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamChannelConfigurations(Consumer<TeamsChannelConfiguration.Builder> ... teamChannelConfigurations) {
            this.teamChannelConfigurations(Stream.of(teamChannelConfigurations).map(c -> (TeamsChannelConfiguration)((TeamsChannelConfiguration.Builder)TeamsChannelConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMicrosoftTeamsChannelConfigurationsResponse build() {
            return new ListMicrosoftTeamsChannelConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChatbotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMicrosoftTeamsChannelConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder teamChannelConfigurations(Collection<TeamsChannelConfiguration> var1);

        public Builder teamChannelConfigurations(TeamsChannelConfiguration ... var1);

        public Builder teamChannelConfigurations(Consumer<TeamsChannelConfiguration.Builder> ... var1);
    }
}

