/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionStatus {
    STANDBY("STANDBY"),
    PENDING("PENDING"),
    EXECUTION_IN_PROGRESS("EXECUTION_IN_PROGRESS"),
    EXECUTION_SUCCESS("EXECUTION_SUCCESS"),
    EXECUTION_FAILURE("EXECUTION_FAILURE"),
    REVERSE_IN_PROGRESS("REVERSE_IN_PROGRESS"),
    REVERSE_SUCCESS("REVERSE_SUCCESS"),
    REVERSE_FAILURE("REVERSE_FAILURE"),
    RESET_IN_PROGRESS("RESET_IN_PROGRESS"),
    RESET_FAILURE("RESET_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionStatus> VALUE_MAP;
    private final String value;

    private ActionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionStatus> knownValues() {
        EnumSet<ActionStatus> knownValues = EnumSet.allOf(ActionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionStatus.class, ActionStatus::toString);
    }
}

