/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.Action;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse;

public class DescribeBudgetActionsForAccountPublisher
implements SdkPublisher<DescribeBudgetActionsForAccountResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeBudgetActionsForAccountRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBudgetActionsForAccountPublisher(BudgetsAsyncClient client, DescribeBudgetActionsForAccountRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBudgetActionsForAccountPublisher(BudgetsAsyncClient client, DescribeBudgetActionsForAccountRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBudgetActionsForAccountResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBudgetActionsForAccountResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Action> actions() {
        Function<DescribeBudgetActionsForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.actions() != null) {
                return response.actions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBudgetActionsForAccountResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBudgetActionsForAccountResponseFetcher
    implements AsyncPageFetcher<DescribeBudgetActionsForAccountResponse> {
        private DescribeBudgetActionsForAccountResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetActionsForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBudgetActionsForAccountResponse> nextPage(DescribeBudgetActionsForAccountResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetActionsForAccountPublisher.this.client.describeBudgetActionsForAccount(DescribeBudgetActionsForAccountPublisher.this.firstRequest);
            }
            return DescribeBudgetActionsForAccountPublisher.this.client.describeBudgetActionsForAccount((DescribeBudgetActionsForAccountRequest)((Object)DescribeBudgetActionsForAccountPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

